<?php


namespace App\Validators\Delivery;

use Prettus\Validator\Contracts\ValidatorInterface;
use Prettus\Validator\LaravelValidator;

class IfoodOrderValidator extends LaravelValidator
{
    protected $rules = [
        ValidatorInterface::RULE_CREATE => [
            "reference" => "required",
            "displayId" => "required",
            "createdAt" => "required|date",
            "payments" => 'required|array|min:1',
            "payments.methods.*.method" => "required",
            "payments.methods.*.value" => "required|numeric",
            "payments.prepaid" => "required|numeric",
            "customer" => 'required|array',
            "customer.name" => "required",
            "items" => 'required|array|min:1',
            "items.*.name" => "required",
            "items.*.quantity" => "required|numeric",
            "items.*.totalPrice" => "required|numeric",
            "total" => 'required|array',
            "total.orderAmount" => 'required|numeric',
            "total.deliveryFee" => 'required|numeric',
            "delivery.deliveryAddress" => 'required|array|min:1',
            "delivery.deliveryAddress.formattedAddress" => "required",
            "delivery.deliveryAddress.country" => "required",
            "delivery.deliveryAddress.state" => "required",
            "delivery.deliveryAddress.city" => "required",
            "delivery.deliveryAddress.neighborhood" => "required",
            "delivery.deliveryAddress.streetName" => "required",
            "delivery.deliveryAddress.streetNumber" => 'required',
            "delivery.deliveryAddress.postalCode" => 'required',
        ],
        ValidatorInterface::RULE_UPDATE => []
        ];
}
