<?php

/*
|--------------------------------------------------------------------------
| Model Factories
|--------------------------------------------------------------------------
|
| Here you may define all of your model factories. Model factories give
| you a convenient way to create models for testing and seeding your
| database. Just tell the factory how a default model should look.
|
*/

use App\Entities\Nati\MicroTerminal;

/* @var $factory \Illuminate\Database\Eloquent\Factory */
$factory->define(MicroTerminal::class, function (Faker\Generator $faker) {

    return [
        'idMicroTerminal' => $faker->localIpv4(),
        'stMicroTerminal' => $faker->text(20),
        'stTipo' => $faker->randomElement($array = [1, 2, 3, 4, 5, 6]),
        'nrPorta' => 6550,
        'nrTeclas' => $faker->randomElement($array = [16, 44]),
        'flLeitor' => $faker->boolean(),
        'flOperador' => $faker->boolean(),
        'stBalanca' => $faker->randomElement($array = ['SEM BALANCA', 'FILIZOLA', 'FILIZOLA_NOVA', 'TOLEDO', 'TOLEDOPRT5', 'CEF', 'PRODIGITAL']),
        'stMarcaPrint' => $faker->randomElement($array = ['SEM IMPRESSORA', 'GENERICA', 'BEMATECH', 'EPSON', 'DARUMA', 'TANCA']),
        'flPrint' => $faker->boolean(),
        'stTipoPorta' => 'SERIAL',
        'flPrintAll' => $faker->boolean(),
        'nrCOMDisplay' => 1,
        'stDisplay' => $faker->text(30),
        'flAtivo'   => $faker->boolean(),
        'dtAlteracao' => $faker->dateTime(),
        'nrTabelaPreco' => $faker->randomElement($array = [1,2]),
    ];
});
