<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCxContraValesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('cx_ContraVales')) {
            Schema::create('cx_ContraVales', function (Blueprint $table) {
                $table->integer('idContraVale', false, true);
                $table->integer('idVenda', false, true);
                $table->integer('idAbertura', false, true);
                $table->decimal('vrContraVale', 9, 2);
                $table->boolean('flBloqueado');
                $table->boolean('flRecebido');
                $table->dateTime('dtEmissao');
                $table->integer('nrDiasValidade');
                $table->dateTime('dtExpiracao');
                $table->boolean('flBaixaManual');
                $table->dateTime('dtRecebimento');
                $table->integer('idOperador');
                $table->integer('idOperadorAutorizador');
                $table->dateTime('dtDesativacao');
                $table->decimal('vrVenda', 9, 2);
                $table->boolean('flAtivo');
                $table->dateTime('dtAlteracao');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cx_ContraVales');
    }
}
