<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCxTaxasTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('cx_Taxas')) {
            Schema::create('cx_Taxas', function (Blueprint $table) {
                $table->dateTime('dtAlteracao');
                $table->bigInteger('idTaxa');
                $table->string('stDescricao', 30);
                $table->dateTime('dtData');
                $table->decimal('vrTaxa', 9, 2);
                $table->integer('idFormaPagamento');
                $table->boolean('flCompensado');
                $table->boolean('flAtivo');

                $table->primary('idTaxa');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cx_Taxas');
    }
}
