<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCxVendasItensExcluidosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('cx_vendas_itens_excluidos')) {
            Schema::create('cx_vendas_itens_excluidos', function (Blueprint $table) {
                $table->increments('idvendasitemexcluido');
                $table->integer('idabertura');
                $table->integer('idoperador');
                $table->integer('idproduto');
                $table->decimal('valor', 9, 3);
                $table->dateTime('data_exclusao');
                $table->dateTime('dtAlteracao');
            });

        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cx_vendas_itens_excluidos');
    }
}
