<?php

use Carbon\Carbon;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePrdMedidasTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('prd_Medidas')) {
            Schema::create('prd_Medidas', function (Blueprint $table) {
                $table->integer('idMedida', false, true);
                $table->string('stMedida', 50);
                $table->boolean('flFracionado')->default(false);
                $table->boolean('flAtivo')->default(true);
                $table->dateTime('dtAlteracao')->default(Carbon::now());
                $table->string('stDescricao', 50);
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('prd_Medidas');
    }
}
