<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMtAdiantamentosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('mt_Adiantamentos')){
            Schema::create('mt_Adiantamentos', function (Blueprint $table) {
                if(Schema::getColumnType('mt_Atendimentos', 'idComanda') == 'integer') {
                    $table->Integer('idComanda');
                } else {
                    $table->smallInteger('idComanda');
                };
                $table->unsignedInteger('idAdiantamento');
                $table->unsignedInteger('idAbertura');
                $table->smallInteger('idCaixa');
                $table->decimal('vrAdiantamento', 18,2);
                $table->unsignedInteger('idFormaPagamento');
                $table->string('stCliente', 100);
                $table->boolean('flAtivo')->default(true);
                $table->dateTime('dtData')->default(\Carbon\Carbon::now());
                $table->string('stOperador', 50);
                $table->string('stOperadorAutorizador', 50);
                $table->dateTime('dtAlteracao')->default(\Carbon\Carbon::now());

                $table->primary(['idComanda', 'idAdiantamento', 'idAbertura']);

                $table->foreign('idComanda')
                    ->references('idComanda')
                    ->on('mt_Atendimentos')
                    ->onDelete('cascade');


                $table->foreign('idAbertura')
                    ->references('idAbertura')
                    ->on('cx_Gerenciador');
            });
        }

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('mt_Adiantamentos');
    }
}
