<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePrdConfigTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('prd_Config')) {

            DB::statement('CREATE TABLE [dbo].[prd_Config](
                  [idConfig] [int] NOT NULL,
                  [flDtAlteracao] [int] NOT NULL,
                  [flCodigo] [int] NOT NULL,
                  [flDesc] [int] NOT NULL,
                  [flDescAbr] [int] NOT NULL,
                  [flCategoria] [int] NOT NULL,
                  [flSubCategoria] [int] NOT NULL,
                  [flMedidaCompra] [int] NOT NULL,
                  [flMedidaVenda] [int] NOT NULL,
                  [flSetor] [int] NOT NULL,
                  [flVrCompra] [int] NOT NULL,
                  [flVrVenda] [int] NOT NULL,
                  [flAliquota] [int] NOT NULL,
                  [dtAlteracao] [datetime] NOT NULL CONSTRAINT [DF_prd_Config_dtAlteracao]  DEFAULT (getdate()),
                  [flNCM] [int] NOT NULL,
                  [stBalanca] [nvarchar](max) NULL,
                  CONSTRAINT [PK_prd_Config] PRIMARY KEY CLUSTERED
                    (
                      [idConfig] ASC
                    )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
                ) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]');
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('prd_Config');

    }
}
