/* 
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
function Util(){ var inverteData; var adicionaDiasAData; var getDataAtual; var validaCpf; var validaCnpj; }

Util.inverteData = function(data){
    var barra = new String(data).substr(2, 1);
    if(barra == "/"){//data em formato brasileiro
        var DATA = data.split('/');
        data = DATA[2]+"-"+DATA[1]+"-"+DATA[0];
    }else{//data em formato americano
        var DATA = data.split('-');
        data = DATA[2]+"/"+DATA[1]+"/"+DATA[0];
    }
return data;
}

Util.adicionaDiasAData = function (qnt_dias, data){
    var DATA = data.split('/');
    DATA[0] = parseInt(DATA[0]);
    DATA[1] = parseInt(DATA[1]);
    DATA[2] = parseInt(DATA[2]);
    var MESES_31 = [1, 3, 5, 7, 8, 10, 12];
    var MESES_30 = [4, 6, 9, 11];
    var qnt_dias_mes;
    qnt_dias = parseInt(qnt_dias);
    
    do{
        if($.inArray(DATA[1], MESES_31) != -1)
            qnt_dias_mes = 31;
        else if($.inArray(DATA[1], MESES_30) != -1)
            qnt_dias_mes = 30;
        else
            qnt_dias_mes = ((DATA[2] % 4 == 0) && ((DATA[2] % 100 != 0) || (DATA[2] % 400 == 0))) ? 29 : 28;
        
        //se for o ultimo dia do mes
        if(DATA[0] == qnt_dias_mes){
            DATA[1] = (DATA[1] == 12) ? 1 : ++DATA[1];//vai para o proximo ms
            DATA[0] = 1;//vai para o primeiro dia do ms
            DATA[2] = (DATA[1] == 12) ? ++DATA[2] : DATA[2];//se for o ultimo ms do ano, adiciona mais um ano a data
        }else{
            DATA[0]++;//incrementa mais um dia a data
        }
    qnt_dias--;
    }while(1 <= qnt_dias);
    
    DATA[0] = (new String(DATA[0]).length == 1) ? "0"+DATA[0] : DATA[0];
    DATA[1] = (new String(DATA[1]).length == 1) ? "0"+DATA[1] : DATA[1];

return DATA[0]+"/"+DATA[1]+"/"+DATA[2];
}

Util.getDataAtual = function(){
    var objData = new Date();
    var dia = (objData.getDate().toString().length == 1) ? "0"+objData.getDate() : objData.getDate();
    var mes = ((objData.getMonth() + 1).toString().length == 1) ? "0"+(objData.getMonth() + 1) : (objData.getMonth() + 1);
    var ano = objData.getFullYear();
    var data = dia+"/"+mes+"/"+ano;
    
    return data;
}

Util.validaCpf = function (str){
    str = str.replace('.','');
    str = str.replace('.','');
    str = str.replace('-','');
 
    cpf = str;
    var numeros, digitos, soma, i, resultado, digitos_iguais;
    digitos_iguais = 1;
    if (cpf.length < 11)
        return false;
    for (i = 0; i < cpf.length - 1; i++)
        if (cpf.charAt(i) != cpf.charAt(i + 1)){
            digitos_iguais = 0;
            break;
        }
    if (!digitos_iguais){
        numeros = cpf.substring(0,9);
        digitos = cpf.substring(9);
        soma = 0;
        for (i = 10; i > 1; i--)
            soma += numeros.charAt(10 - i) * i;
        resultado = soma % 11 < 2 ? 0 : 11 - soma % 11;
        if (resultado != digitos.charAt(0))
            return false;
        numeros = cpf.substring(0,10);
        soma = 0;
        for (i = 11; i > 1; i--)
            soma += numeros.charAt(11 - i) * i;
        resultado = soma % 11 < 2 ? 0 : 11 - soma % 11;
        if (resultado != digitos.charAt(1))
            return false;
        return true;
    }
    else
        return false;
}

Util.validaCnpj = function (str){
    str = str.replace('.','');
    str = str.replace('.','');
    str = str.replace('.','');
    str = str.replace('-','');
    str = str.replace('/','');
    cnpj = str;
    var numeros, digitos, soma, i, resultado, pos, tamanho, digitos_iguais;
    digitos_iguais = 1;
    if (cnpj.length < 14 && cnpj.length < 15)
        return false;
    for (i = 0; i < cnpj.length - 1; i++)
        if (cnpj.charAt(i) != cnpj.charAt(i + 1))
    {
        digitos_iguais = 0;
        break;
    }
    if (!digitos_iguais)
    {
        tamanho = cnpj.length - 2
        numeros = cnpj.substring(0,tamanho);
        digitos = cnpj.substring(tamanho);
        soma = 0;
        pos = tamanho - 7;
        for (i = tamanho; i >= 1; i--)
        {
            soma += numeros.charAt(tamanho - i) * pos--;
            if (pos < 2)
                pos = 9;
        }
        resultado = soma % 11 < 2 ? 0 : 11 - soma % 11;
        if (resultado != digitos.charAt(0))
            return false;
        tamanho = tamanho + 1;
        numeros = cnpj.substring(0,tamanho);
        soma = 0;
        pos = tamanho - 7;
        for (i = tamanho; i >= 1; i--)
        {
            soma += numeros.charAt(tamanho - i) * pos--;
            if (pos < 2)
                pos = 9;
        }
        resultado = soma % 11 < 2 ? 0 : 11 - soma % 11;
        if (resultado != digitos.charAt(1))
            return false;
        return true;
    }
    else
        return false;
}