<?php

use Koolreport\KoolReport;

class VendasMotoboy extends KoolReport
{
    protected function settings()
    {
        return [
            "automaker"=>array(
                "connectionString"=>"sqlsrv:server=localhost;Database=nati2",
                "username"=>"sa",
                "password"=>"cecon",
                "charset"=>"utf8"
            ),
        ];
    }

    protected function setup()
    {
        $this->src("automaker")
            ->query("
             select x.stMotoBoy, x.stFormaPagamento, sum(total) as vrTotal from (
                        select m.stMotoBoy, fp.stFormaPagamento,sum(i.vrTotal) as total
                        from dlv_Itens i
                        inner join dlv_Atendimentos a on a.idAtendimento = i.idAtendimento
                        inner join dlv_Motoboy m on m.idMotoboy = a.idMotoboy
                        inner join dlv_FichaPagamentos p on a.idAtendimento = p.idAtendimento
                        inner join cx_FormasPagamento fp on fp.idFormaPagamento = p.idFormaPagamento
                        where a.flAtivo = '1'  and a.dtAbertura between '2020-01-01 00:00:00' and '2020-08-29 23:59:59'
                        group by m.stMotoBoy, fp.stFormaPagamento
						) as x group by x.stMotoBoy, x.stFormaPagamento
            ")
            ->pipe($this->dataStore("result"));
    }
}
