function getDocNotaFiscal() {
	toastr.options = 
	{
		"positionClass": "toast-top-right"
	}
	var texto = $("#stNota").val();
	if(texto == "" || texto == null){
		toastr.error("Digite algo antes de fazer a busca.");
		return false;
	}
	var data = {action: "getDocByNota", texto: texto};
	$.post('estoque/resources/php/editarNota_functions.php', data, function (data) {
		if(data){
			$("#divBuscaDocumento").attr("hidden", "hidden");
			var headers = '<tr bgcolor="#2A98D3" style="color:white"><td width="40%">Documento</td><td width="25%">Data</td><td width="25%">Operador</td><td width="10%">Ação</td></tr>';
			$(headers).appendTo($("#tHeadBusca"));
			var rows = '';
			for (var i = 0; i < data.length; i++) {
				rows += '<tr><td>'+data[i].stNotaFiscal+'</td>'+
				'<td>'+data[i].dtData+'</td>'+
				'<td>'+data[i].stOperador+'</td>'+
				'<td align="center"><a onclick="visualizarNota('+data[i].idMovimentacao+')" style="cursor: pointer;"><span class="glyphicon glyphicon-search" title="Visualizar"></span></a></td>';
			}
			$(rows).appendTo($("#tBodyBusca"));
			$("#divResultadoBusca").removeAttr("hidden");
		}else{
			toastr.error("Nenhuma nota encontrada com esse número.");
		}
	});
}

function getDocFornecedor() {
	toastr.options = 
	{
		"positionClass": "toast-top-right"
	}
	var texto = $("#stFornecedor").val();
	if(texto == "" || texto == null){
		toastr.error("Digite algo antes de fazer a busca.");
		return false;
	}
	var data = {action: "getDocByFornecedor", texto: texto};
	$.post('estoque/resources/php/editarNota_functions.php', data, function (data) {
		if(data){
			$("#divBuscaDocumento").attr("hidden", "hidden");
			var headers = '<tr bgcolor="#2A98D3" style="color:white"><td width="25%">Documento</td><td width="25%">Fornecedor</td><td width="20%">Data</td><td width="20%">Operador</td><td width="10%">Ação</td></tr>';
			$(headers).appendTo($("#tHeadBusca"));
			var rows = '';
			for (var i = 0; i < data.length; i++) {
				rows += '<tr><td>'+data[i].stNotaFiscal+'</td>'+
				'<td>'+data[i].stNomeFornecedor+'</td>'+
				'<td>'+data[i].dtData+'</td>'+
				'<td>'+data[i].stOperador+'</td>'+
				'<td align="center"><a onclick="visualizarNota('+data[i].idMovimentacao+')" style="cursor: pointer;"><span class="glyphicon glyphicon-search" title="Visualizar"></span></a></td>';
			}
			$(rows).appendTo($("#tBodyBusca"));
			$("#divResultadoBusca").removeAttr("hidden");
		}else{
			toastr.error("Nenhuma nota encontrada com esse número.");
		}
	});
}

function visualizarNota(idMovimentacao) {
	var data = {action: "getDadosNota", idMovimentacao: idMovimentacao};
	$.post('estoque/resources/php/editarNota_functions.php', data, function (data) {
		if(data){
			$("#origem").html(data.stOrigem);
			$("#destino").html(data.stDestino);
			$("#stNotaFiscal").html(data.stNotaFiscal);
			$("#stDocumento").val(data.stNotaFiscal);
			$("#dataNota").html(data.dtMovimentacao);
			$("#areaobservacao").html(data.stObs);
			$("#idMovimentacao").val(data.idMovimentacao);
			$("#idOrigem").val(data.idOrigem);
			$("#idDestino").val(data.idDestino);
			$("#flTipoEstoque").val(data.flTipoEstoque);
		}
	});

	var data = {action: "getProdutosNota", idMovimentacao: idMovimentacao};
	$.post('estoque/resources/php/editarNota_functions.php', data, function (data) {
		if(data){
			var linha = "";
			var vrTotal = 0;
			for (var i = 0; i < data.length; i++) {
				var medidaProduto = "";
				var qtdConversao = "1";
				var qtdConvertida = 0;

				if(data[i].stMedidaConversao != data[i].stMedida){
					medidaProduto = data[i].stMedida;
				}else{
					medidaProduto = data[i].stMedidaConversao;
				}

				if(data[i].nrQuantidadeConversao > 0){
					qtdConversao = data[i].nrQuantidadeConversao;
				}

				if(data[i].flFracionado > 0){
					qtdConvertida = data[i].nrQuantidade / 1000;
				}else{
					qtdConvertida = data[i].nrQuantidade;
				}

				vrTotal += data[i].vrValor * (qtdConvertida * qtdConversao);

				linha = '<tr id="row'+ data[i].idProduto +'">'+
				'<input type="hidden" id="idCodigoProduto'+data[i].idProduto+'" name="idCodigoProduto'+data[i].idProduto+'" value="'+data[i].idCodigo+'">'+
				'<input type="hidden" id="flFracionado'+data[i].idProduto+'" name="flFracionado'+data[i].idProduto+'" value="'+data[i].flFracionado+'">'+
				'<td>'+data[i].idCodigo+'</font></td>'+
				'<td>'+data[i].stProduto+'</font></td>'+
				'<td align="right">'+data[i].nrQtd1+'</font></td>'+
				'<td align="right">'+data[i].nrQtd2+'</font></td>'+
				'<td><input class="form-control input-sm" id="stMedidaConversao'+data[i].idProduto+'" name="stMedidaConversao'+data[i].idProduto+'" maxlength="5" type="text" value="'+medidaProduto+'"></td>'+
				'<td><input class="form-control input-sm" id="stQuantidadeConversao'+data[i].idProduto+'" name="stQuantidadeConversao'+data[i].idProduto+'" maxlength="10" type="text" value="'+qtdConversao+'"></td>'+
				'<td><input class="form-control input-sm" id="vrCusto'+data[i].idProduto+'" name="vrCusto'+data[i].idProduto+'" value="'+(data[i].vrValor * qtdConversao).toFixed(2)+'" maxlength="18" type="text" onkeyup="calculaProduto(this.id); nextInput('+ data.idProduto +', event)"></td>'+
				'<td><input class="form-control input-sm" id="nrQuantidade'+data[i].idProduto+'" name="nrQuantidade'+data[i].idProduto+'" maxlength="10" type="text" value="'+data[i].nrQuantidade+'" onkeyup="calculaProduto(this.id); nextInput(null, event)"></td>'+
				'<td><input class="form-control input-sm" id="vrTotal'+data[i].idProduto+'" name="vrTotal'+data[i].idProduto+'" maxlength="18" type="text" readonly value="'+(data[i].vrValor * (qtdConvertida * qtdConversao)).toFixed(2)+'"></td>'+
				'<td align="center"><a onclick="removerProduto('+data[i].idProduto+')" ><span class="glyphicon glyphicon-remove" data-toogle="tooltip" title="Excluir Produto"></span></a></td>';
				if(data[i].stSetor){
					var setor = data[i].stSetor.split(" ");
				}else{
					var setor = "SEM SETOR";
				}
				if($("#setor" + setor[0]).length > 0){
					$(linha).insertAfter($("#setor" + setor[0]));
				}else{
					var novaArea ="<tr bgcolor=#E2F0F9 id=setor" + data[i].stSetor + ">" +
					"<td colspan=13><font size=2><center><b>" + data[i].stSetor + "</b></center></font></td>" +
					"</tr>";
					novaArea += linha;
					$(novaArea).appendTo($("#bodyTabelaProduto"));
				}
				if(data[i].flFracionado){
					$("#stMedidaConversao"+ data[i].idProduto +"").attr("readonly", "readonly");
					$("#stQuantidadeConversao"+ data[i].idProduto +"").attr("readonly", "readonly");
				}
			}
			$("#totalNota").val(vrTotal.toFixed(2));
			$("#divResultadoBusca").attr("hidden", "hidden");
			$("#divNotaFiscal").removeAttr("hidden");
		}
	});
}

function numbersOnly(e) {
	if (e.which != 8 && e.which != 0 && (e.which < 48 || e.which > 57)) {
		return false;
	}
}

$('#selectProduto').on("select2:select", function (e) {
	$('#btnAddProduto').focus();
});

function checkPress (e, tipo) {
	if( e.keyCode == 13 ){
		if (tipo == "nota") {
			getDocNotaFiscal();
		}else{
			getDocFornecedor();
		}
	}
}

function removerProduto(codProduto) {
	var totalProduto = parseFloat($("#vrTotal" + codProduto + "").val().replace(",", "."));
	var totalNota = parseFloat($("#totalNota").val().replace(",", "."));
	$("#totalNota").val((totalNota - totalProduto).toFixed(2));
	$("#nrQuantidade"+ codProduto +"").val("0");
	$("#row"+ codProduto +"").attr("hidden", "hidden");
}

function checkValues() {
	toastr.options = 
	{
		"positionClass": "toast-bottom-right"
	}
	var trans = false;
	var count = 0;
	$("input[id*=nrQuantidade]").each(function () {
		if(this.value > 0){
			trans = true;
		}
		count ++;
	});
	if (count == 0) {
		trans = false;
	}
	if(trans){
		$("#cadastro").submit();
	}else{
		toastr.error("Você precisar fazer o lançamento de no mínimo 1 produto. Adicione um produto");
	}
}

function procurarProduto (tipo) {
	toastr.options={
		"positionClass": "toast-top-right"
	};
	var product = $("#procuraProduto").val();
	var origem = $("#idOrigem").val();
	if(tipo == "Nome"){
		var data = {action: "getProdutoNome", productText: product, idOrigem: origem};
	}else{
		var data = {action: "getProdutoNumero", productText: product, idOrigem: origem};
	}
	$.post('estoque/resources/php/editarNota_functions.php', data, function (data) {
		if(data.status == false){
			toastr.error(data.msg);
			return false;
		}
		for (var i = 0; i < data.length; i++) {
			$('#idProdutoAdicionar').append($("<option></option>").attr("value", data[i].idProduto).text(data[i].stProduto));
		}
		$("#modalAddProduto").modal('show');
	});
}

$("#modalAddProduto").on("hidden.bs.modal", function(){
	$("#idProdutoAdicionar").html("");
});

function adicionarProduto() {
	toastr.options={
		"positionClass": "toast-top-right"
	};
	var escolhido = $("#selectProduto option:selected").val();
	var origem = $("#idOrigem").val();
	var destino = $("#idDestino").val();
	var movimentacao = $("#idMovimentacao").val();
	var data = {action: "adicionaProduto", idProduto: escolhido, idOrigem: origem, idDestino: destino, idMovimentacao: movimentacao};
	$.post('estoque/resources/php/editarNota_functions.php', data, function (data) {
		if(data){
			if($("#row"+ data.idProduto +"").html()){
				toastr.error("Produto já foi adicionado");
				$('#selectProduto').select2("open");
			}else{
				toastr.success("Produto adicionado com sucesso");

				var medidaProduto = "";
				var qtdConversao = "1";
				var qtdConvertida = 0;

				if(data.stMedidaConversao != data.stMedida){
					medidaProduto = data.stMedida;
				}else{
					medidaProduto = data.stMedidaConversao;
				}

				if(data.nrQuantidadeConversao > 0){
					qtdConversao = data.nrQuantidadeConversao;
				}

				if(data.flFracionado > 0){
					qtdConvertida = data.nrQuantidade / 1000;
				}else{
					qtdConvertida = data.nrQuantidade;
				}

				var linha = '<tr id="row'+ data.idProduto +'">'+
				'<input type="hidden" id="idCodigoProduto'+data.idProduto+'" name="idCodigoProduto'+data.idProduto+'" value="'+data.idCodigo+'">'+
				'<input type="hidden" id="flFracionado'+data.idProduto+'" name="flFracionado'+data.idProduto+'" value="'+data.flFracionado+'">'+
				'<td>'+data.idCodigo+'</font></td>'+
				'<td>'+data.stProduto+'</font></td>'+
				'<td align="right">'+data.nrQtd1+'</font></td>'+
				'<td align="right">'+data.nrQtd2+'</font></td>'+
				'<td><input class="form-control input-sm" id="stMedidaConversao'+data.idProduto+'" name="stMedidaConversao'+data.idProduto+'" maxlength="5" type="text" value="'+medidaProduto+'"></td>'+
				'<td><input class="form-control input-sm" id="stQuantidadeConversao'+data.idProduto+'" name="stQuantidadeConversao'+data.idProduto+'" maxlength="10" type="text" value="'+qtdConversao+'" onkeyup="calculaProduto(this.id)"></td>'+
				'<td><input class="form-control input-sm" id="vrCusto'+data.idProduto+'" name="vrCusto'+data.idProduto+'" value="'+(data.vrCusto * qtdConversao).toFixed(2)+'" maxlength="18" type="text" onkeyup="calculaProduto(this.id);  nextInput('+ data.idProduto +', event)"></td>'+
				'<td><input class="form-control input-sm" id="nrQuantidade'+data.idProduto+'" name="nrQuantidade'+data.idProduto+'" maxlength="10" type="text" value="'+data.nrQuantidade+'" onkeyup="calculaProduto(this.id); nextInput(null, event)"></td>'+
				'<td><input class="form-control input-sm" id="vrTotal'+data.idProduto+'" name="vrTotal'+data.idProduto+'" maxlength="18" type="text" readonly value="'+(data.vrCusto * qtdConvertida).toFixed(2)+'" readonly></td>'+
				'<td align="center"><a onclick="removerProduto('+data.idProduto+')" ><span class="glyphicon glyphicon-remove" data-toogle="tooltip" title="Excluir Produto"></span></a></td>';
				if(data.stSetor){
					var setor = data.stSetor.split(" ");
				}else{
					var setor = "SEM SETOR";
				}
				if($("#setor" + setor[0]).length > 0){
					$(linha).insertAfter($("#setor" + setor[0]));
				}else{
					var novaArea ="<tr bgcolor=#E2F0F9 id=setor" + data.stSetor + ">" +
					"<td colspan=13><font size=2><center><b>" + data.stSetor + "</b></center></font></td>" +
					"</tr>";
					novaArea += linha;
					$(novaArea).appendTo($("#bodyTabelaProduto"));
				}
				if(data.flFracionado){
					$("#stMedidaConversao"+ data.idProduto +"").attr("readonly", "readonly");
					$("#stQuantidadeConversao"+ data.idProduto +"").attr("readonly", "readonly");
				}
				calculaTotal();
				$("#vrCusto"+ data.idProduto).focus();
			}
		}
	});
}

function nextInput (idProduto, e) {
	if( e.keyCode == 13 ){
		if(idProduto){
			$("#vrQuantidade"+ idProduto).val("");
			$("#nrQuantidade"+ idProduto).focus();
		}else{
			$('#selectProduto').select2("open");
		}
	}
}

$('#selectProduto').select2({
	placeholder: "Digite o Nome do Produto",
	multiple: false,
	width: '100%',
	theme: "bootstrap",
	ajax: {
		url: "estoque/resources/php/editarNota_functions.php",
		dataType: 'json',
		type: "POST",
		delay: 250,
		data: function (params) {
			return {
				action: 'popularProduto',
        		texto: params.term, // search term
        		page: params.page
        	};
        },
        processResults: function (data) {
        	return {
        		results: $.map(data, function (item) {
        			return {
        				text: item.idCodigo + " - " + item.stProduto,
        				id: item.idProduto
        			}
        		})
        	}
        }
    }
});

function calculaTotal() {
	var totalNota = 0;
	var totais = $("input[id*=vrTotal]").each(function() {
		totalNota += parseFloat((this.value).replace(",","."));
	});
	totalNota = totalNota.toFixed(2);
	$("#totalNota").val(totalNota);
}

function removerProduto(input) {
	var row = $("#row"+input);
	row.remove();
	calculaTotal(input);
}

function calculaProduto(idInput) {
	idProduto = idInput.replace(/\D/g,'');
	var flFracionado = $("#flFracionado"+idProduto).val();
	var custo = parseFloat($("#vrCusto"+idProduto).val().replace(",","."));
	var quantidade = $("#nrQuantidade"+idProduto).val().replace(",",".");
	var conversao = $("#stQuantidadeConversao"+idProduto).val();

	if (flFracionado != "0") {
		quantidade = quantidade/1000;
	}
	var novoTotal = ((custo * (quantidade * conversao)).toFixed(2)).replace(".",",");
	$("#vrTotal"+idProduto).val(novoTotal);
	calculaTotal();
}

function salvarEdicaoNota() {
	toastr.options={
		"positionClass": "toast-top-right"
	};
	var produtos = 0;
	var totais = $("input[id*=nrQuantidade]").each(function() {
		if(this.value != "0" && this.value != "") {
			produtos++;
		}
	});
	if(produtos == 0){
		toastr.error("Para fazer um lançamento deve haver no mínimo um produto.");
		return false;
	}else{
		var data = $("#edicaoNota").serialize();
		$("body").addClass("loading");
		$.post('estoque/takeeditarnota.php', data , function (data) {
			$("body").removeClass("loading");
			if(data == "success"){
				toastr.success("Nota Fiscal editada com sucesso!");
				setTimeout(function() {
					document.location = "?sec=estoque&sub=editarnota";
				}, 2000);
			}else{
				toastr.error("Ocorreu um erro ao salvar os dados.");
			}
		});
	}
}
