<?php
require_once "../functions.php";

db_conn();

if (autorization(7) == false)
{
	?>
	<SCRIPT>
		document.location = "../?sec=erro&sub=2";
	</SCRIPT>
	<?
	die;
}

$idAbertura = htmlspecialchars($_GET['ida'], ENT_QUOTES);
$idVenda = htmlspecialchars($_GET['idv'], ENT_QUOTES);
?>
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	<title>Itens da venda <?php echo $idVenda?></title>
	<style>
		body
		{
			font-family: arial;
			font-size: 10pt;
		}
		a:link, a:visited
		{
			text-decoration: none;
			color: #0C6295;
		}
		a:hover
		{
			text-decoration: underline;
			color: #0C6295;
		}
	</style>
	<link href="resources/css/bootstrap.min.css" rel="stylesheet"/>
	<link href="resources/css/datatables.min.css" rel="stylesheet" type="text/css"/>
	<link href="resources/css/toastr.css" rel="stylesheet"/>
	<link href="resources/css/sweetalert2.css" rel="stylesheet"/>
	<link href="resources/css/custom.css" rel="stylesheet"/>
</head>
<body>
	<table class="display table table-striped table-bordered" width="100%" cellpadding="3" cellspacing="0" border="1" style="border-collapse: collapse" bordercolor="#FFFFFF">
		<caption class="table-caption"><b>Itens da venda <?php echo $idVenda?></b></caption>
		<tr>
			<td class="tdStyle" width="15%"><b>Operador</b></td>
			<td class="tdStyle" width="20%"><b>Código</b></td>
			<td class="tdStyle" width="35%"><b>Produto</b></td>
			<td class="tdStyle" width="10%"><b>Quantidade</b></td>
			<td class="tdStyle" width="20%" align="right"><b>Total</b></td>
		</tr>
		<?
		$sql = "SELECT I.idCodProduto, I.idProduto, P.stProduto, M.stMedida, M.flFracionado, I.nrQuantidade, I.vrTotal, stAtendente ".
		"FROM cx_Itens_Temp I ".
		"INNER JOIN prd_Produtos P ON I.idProduto = P.idProduto ".
		"INNER JOIN prd_Medidas M ON M.idMedida = P.idMedida ".
		"WHERE I.idAbertura = '$idAbertura' AND I.idVenda = '$idVenda' AND I.flAtivo = '1'";

		$res = mssql_query($sql);

		while ($arr = mssql_fetch_array($res))
		{
			if ($arr['flFracionado'])
				$nrQuantidade = number_format(($arr['nrQuantidade'] / 1000), 3, ".", "");
			else
				$nrQuantidade = intval($arr['nrQuantidade']);

			$stProduto = $arr['stProduto'];
			$filename = "C://tpt.log";
			if(file_exists($filename) && $arr['idCodProduto'] == -100){
				$stProduto = "TAXA DE SERVIÇO";
			}
			?>
			<tr>
				<td class="tdStyle"><?php echo $arr['stAtendente']?></td>
				<td class="tdStyle"><?php echo $arr['idCodProduto']?></td>
				<td class="tdStyle"><?php echo $stProduto?></td>
				<td class="tdStyle"><?php echo $nrQuantidade?> <?php echo $arr['stMedida']?></td>
				<td class="tdStyle" align="right">R$ <?php echo number_format($arr['vrTotal'], 2, ",", ".")?></td>
			</tr>
			<?
			$totalVenda += $arr['vrTotal'];
		}

		$sql = "SELECT SUM(vrDesconto) as vrDesconto FROM cx_Vendas_Temp WHERE idAbertura = '$idAbertura' AND idVenda = '$idVenda' AND flAtivo = '1'";
		$res = mssql_query($sql);
		$row = mssql_fetch_row($res);
		$vrDesconto = $row[0];

		if ($vrDesconto > 0)
		{
			?>
			<tr>
			<td class="tdStyle" colspan="4">DESCONTO</td>
			<td class="tdStyle" align="right">R$ <?php echo number_format($vrDesconto, 2, ",", ".")?></td>
			</tr>
			<?
		}
		?>
		<tr>
			<td class="tdStyle" colspan="4"><b>Total da Venda:</b></td>
			<td class="tdStyle" align="right"><b>R$ <?php echo number_format(($totalVenda - $vrDesconto), 2, ",", ".")?></b></td>
		</tr>
	</table>
	<br>
	<center><input class="btn btn-nati" type="button" name="btn" value="Voltar" onClick="javascript:history.go(-1)"></center>
</body>
</html>
