document.addEventListener("DOMContentLoaded", function () {
    toastr.options = {"positionClass": "toast-bottom-right"};
    var page = $("#page").val();
    if (page === 'extratoCliente') {
        setDateFields();
    }
});

function filtrarClientes() {
    $("body").addClass("loading");
    var data = {action: 'initExtratoCliente', de: $('#de').val(), ate: $('#ate').val()};
    $.post('relatorios/resources/php/email.php', data, function (response) {
        var linha = '';
        $("#bodyClientes").empty();

        if (response && response.length > 0) {
            for (var i = 0; i < response.length; i++) {
                if (response[i].flNaoEnvia === 1) {
                    linha += "<tr>";
                    linha += "<td><a onclick='gerarExtrato(" + '"' + response[i].idCliente + '"' + ")' style='cursor: pointer; text-decoration:none; font-size:14px'>" + response[i].idCliente + " - " + response[i].stCliente + "</a></td>";
                    linha += "<td style='text-align:center'><input type='checkbox' id='fl" + response[i].idCliente + "' disabled title='Este cliente não tem um endereço de email válido.'/></td>";
                    linha += "<td style='text-align:center'><button type='button' class='btn btn-primary' disabled title='Este cliente não tem um endereço de email válido.'>";
                    linha += "<i class='glyphicon glyphicon-envelope'></i></button>";
                    linha += "</td>";
                    linha += "</tr>";

                } else if (response[i].flNTemMovimento === 1) {
                    linha += "<tr>";
                    linha += "<td style='text-decoration:none; font-size:14px'>" + response[i].idCliente + " - " + response[i].stCliente + "</td>";
                    linha += "<td style='text-align:center'><input type='checkbox' disabled/></td>";
                    linha += "<td style='text-align:center'><button type='button' class='btn btn-primary' onclick='enviarExtrato(" + '"' + response[i].idCliente + '"' + ")' disabled>";
                    linha += "<i class='glyphicon glyphicon-envelope'></i></button>";
                    linha += "</td>";
                    linha += "</tr>";

                } else {
                    linha += "<tr>";
                    linha += "<td><a onclick='gerarExtrato(" + '"' + response[i].idCliente + '"' + ")' style='cursor: pointer; text-decoration:none; font-size:14px'>" + response[i].idCliente + " - " + response[i].stCliente + "</a></td>";
                    linha += "<td style='text-align:center'><input type='checkbox' id='fl" + response[i].idCliente + "'/></td>";
                    linha += "<td style='text-align:center'><button type='button' class='btn btn-primary' onclick='enviarExtrato(" + '"' + response[i].idCliente + '"' + ")'>";
                    linha += "<i class='glyphicon glyphicon-envelope'></i></button>";
                    linha += "</td>";
                    linha += "</tr>";
                }
            }
        } else {

            linha += "<tr><td colspan='4'>NENHUM CLIENTE</td></tr>";
        }

        $(linha).appendTo($("#bodyClientes"));
        $("#clientTable").removeAttr('hidden');
        $("#hiddenTable").removeAttr('hidden');
        $("body").removeClass("loading");
    });
}

$("#checkAll").click(function () {
    $('input:checkbox').not(this).not(':disabled').prop('checked', this.checked);
});

function sendMail(id) {
    $("#idCliente").val(id);
    $("#clientTable").attr('hidden', 'hidden');
    $("#noMail").attr('hidden', 'hidden');
    $("#noMailText").attr('hidden', 'hidden');
    $("#filterPicker").removeAttr('hidden');
    $("#btnMail").removeAttr('hidden');
}

function enviarExtrato(id) {
    toastr.options = {"positionClass": "toast-bottom-right"}
    $("body").addClass("loading");
    var data = {action: 'sendMailExtrato', idCliente: id, de: $('#de').val(), ate: $('#ate').val()};
    $.post('relatorios/resources/php/email.php', data, function (response) {
        if (!response.status) {
            toastr.error(response.msg);
            $("body").removeClass("loading");
        }
    });
    setTimeout(function () {
        $("body").removeClass("loading");
        toastr.success('Email enviado com sucesso.');
    }, 4200);
}

function enviarTodos() {
    $("body").addClass("loading");
    var ids = [];
    $('input:checkbox').each(function () {
        if ($("#" + $(this)[0].id).prop('checked')) {
            var id = $(this)[0].id;
            id = id.replace('fl', '');
            ids.push(id);
        }
    });

    for (var i = 0; i < ids.length; i++) {
        var data = {action: 'sendMailExtrato', idCliente: ids[i], de: $('#de').val(), ate: $('#ate').val()};
        $.post('relatorios/resources/php/email.php', data, function (response) {
        });
    }

    setTimeout(function () {
        toastr.options = {"positionClass": "toast-bottom-right"}
        $("body").removeClass("loading");
        toastr.success('Email enviado com sucesso.');
    }, 5000);

}

function setDateFields() {
    var date = new Date();
    var day = date.getDate();
    if (day < 10) {
        day = '0' + day;
    }
    var month = date.getMonth() + 1;
    if (month < 10) {
        month = '0' + month;
    }
    $('#de').val('01/' + month + '/' + date.getFullYear());
    $('#ate').val(day + '/' + month + '/' + date.getFullYear());
    $('.data').datepicker({
        format: 'dd/mm/yyyy',
        language: 'pt-BR',
        autoclose: true
    });
    $('#de').mask('00/00/0000');
    $('#ate').mask('00/00/0000');
}

function gerarExtrato(id) {
    $("body").addClass("loading");
    var data = {
        action: 'gerarExtrato',
        idCliente: id,
        de: $('#de').val(),
        ate: $('#ate').val(),
        optradio: $('input[name=optradio]:checked').val()
    }

    $.post('relatorios/resources/php/email.php', {action: 'getSaldoAnterior', idCliente: id, date: $('#de').val()}, function (response) {
        $("#saldoAnterior").val(response);
    });

    $.post('relatorios/resources/php/email.php', data, function (response) {
        var totalGeral = 0;
        var saldoTotal = 0;

        var date = new Date();
        var day = date.getDate();
        if (day < 10) {
            day = '0' + day;
        }
        var month = date.getMonth() + 1;
        if (month < 10) {
            month = '0' + month;
        }

        $.post('relatorios/resources/php/email.php', {action: 'getDadosOperador'}, function (operador) {
            $("#tdTitulo").html('Relatório emitido por <b>' + operador['stApelido'] + '</b> [' + operador['idOperador'] + '] em ' + day + '/' + month + '/' + date.getFullYear() + ' às ' + date.getHours() + ':' + date.getMinutes() + 'H');
        });

        $.post('relatorios/resources/php/email.php', {action: 'getDadosCliente', idCliente: id}, function (cliente) {
            $("#infoCliente").html('' + cliente['stCliente'] + ' [ ' + cliente['idCliente'] + ' ]');
            $("#enderecoCliente").html('<b>ENDEREÇO:</b> ' + cliente['stEndereco'] + '');
        });

        $("#filtroTr").attr('hidden', 'hidden');
        $("#clientTable").attr('hidden', 'hidden');
        $("#extratoTr").removeAttr('hidden');
        $("#resultExtrato").removeAttr('hidden');
        var totalDesconto = 0;
        var totalAcrescimo = 0;
        if (response) {
            console.log('response =>', response);
            saldoTotal = response[0]['vrSaldo'];
            $("#tdPeriodo").html('Período do Extrato: <b>' + $('#de').val() + ' - 00:00:00 a ' + $('#ate').val() + ' - 23:59:59</b>');
            linha = '';
            for (var i = 0; i < response.length; i++) {
                var total = 0;
                if(!response[i]['chave_fiscal']) {
                    response[i]['chave_fiscal'] = '';
                }
                linha += '<tr><td colspan="3">';
                linha += '<table width="100%" cellpadding="5" cellspacing="0"><tr>';
                linha += '<td bgcolor="#CCCCCC"><font size="2">' + response[i]['dtData'] + 'H <b> [ ' + response[i]['Tipo'] + ' ] Cf-e: ' + response[i]['chave_fiscal'] + '</b></font></td>';
                linha += '</tr></table></td></tr>';
                if (response[i]['Tipo'] === 'VENDA') {
                    linha += '<tr><td colspan="3"><table width="100%">';
                    if (response[i].vendas) {
                        for (var j = 0; j < response[i].vendas.length; j++) {
                            linha += '<tr>';
                            linha += '<td width="5%" style="padding: 2px"></td>';
                            linha += '<td width="50%" style="padding: 2px"><font size="2">' + response[i].vendas[j]['stProdutoAbreviado'] + '</font></td>';
                            linha += '<td width="10%" style="padding: 2px"><font size="2">' + response[i].vendas[j]['nrQuantidade'] + ' ' + response[i].vendas[j]['stMedida'] + '</font></td>';
                            linha += '<td width="5%" style="padding: 2px"><font size="2"> X </font></td>';
                            linha += '<td width="10%" style="padding: 2px"><font size="2"> R$' + parseFloat(response[i].vendas[j]['vrUnitarioAtual']).toFixed(2) + '</font></td>';
                            linha += '<td width="20%" align="right" style="padding: 2px"><font size="2">R$ ' + parseFloat(response[i].vendas[j]['vrTotal']).toFixed(2) + '</font></td>';
                            linha += '</tr>'
                            console.log('acrescimo =>', response[i]['vrAcrescimo']);
                            var sub = parseFloat(response[i].vendas[j]['vrTotal']);
                            total += parseFloat(sub);
                        }
                    }
                    var subTotal = total - response[i]['vrQuitado'] + response[i]['vrDesconto'];

                    totalGeral += parseFloat(subTotal);
                    totalAcrescimo += parseFloat(response[i]['vrAcrescimo']);

                    if (response[i]['vrQuitado'] > 0) {
                        linha += "<tr>";
                        linha += '<td  style="padding: 2px"></td>';
                        linha += '<td  colspan="2" style="padding: 2px"><font size="2">VALOR QUITADO</font></td>';
                        linha += "<td> </td>";
                        linha += "<td> </td>";
                        linha += '<td  align="right" style="padding: 2px"><font size="2" color="red">R$ ' + parseFloat(response[i]['vrQuitado']).toFixed(2) + '</font></td>';
                        linha += "</tr>";
                    }
                    // //subtotal
                    linha += "<tr>";
                    linha += '<td style="padding: 2px"></td>';
                    linha += '<td colspan="2" style="padding: 2px"><font size="2"><b>SUBTOTAL:</b></font></td>';
                    linha += "<td> </td>";
                    linha += "<td> </td>";
                    linha += '<td  align="right" style="padding: 2px"><font size="2"><b>R$ ' + parseFloat(total).toFixed(2) + '</b></font></td>';
                    linha += "</tr>";
                    //DESCONTO
                    if(response[i]['vrDesconto'] > 0) {
                        linha += "<tr>";
                        linha += '<td style="padding: 2px"></td>';
                        linha += '<td colspan="2" style="padding: 2px"><font size="2"><b>DESCONTO EM VENDA</b></font></td>';
                        linha += "<td> </td>";
                        linha += "<td> </td>";
                        linha += '<td  align="right" style="padding: 2px"><font size="2"><b>R$ ' + parseFloat(response[i]['vrDesconto']).toFixed(2) + '</b></font></td>';
                        linha += "</tr>";
                    }

                    //ACRESCIMO
                    if(response[i]['vrAcrescimo'] > 0) {
                        linha += "<tr>";
                        linha += '<td style="padding: 2px"></td>';
                        linha += '<td colspan="2" style="padding: 2px"><font size="2"><b>ACRESCIMO</b></font></td>';
                        linha += "<td> </td>";
                        linha += "<td> </td>";
                        linha += '<td align="right" style="padding: 2px"><font size="2"><b>R$ ' + parseFloat(response[i]['vrAcrescimo']).toFixed(2) + '</b></font></td>';
                        linha += "</tr>";
                    }

                    //incrementa o desconto
                    totalDesconto += parseFloat(response[i]['vrDesconto']);
                    var totalcompra = parseFloat(total) + parseFloat(response[i]['vrAcrescimo']) + parseFloat(response[i]['vrDesconto']) - parseFloat(response[i]['vrQuitado']);
                    linha += "<tr>";
                    linha += '<td  style="padding: 2px"></td>';
                    linha += '<td  colspan="2" style="padding: 2px"><font size="2"><b>DEBITO EM CONTA</b></font></td>';
                    linha += "<td> </td>";
                    linha += "<td> </td>";
                    linha += '<td  align="right" style="padding: 2px"><font size="2"><b>(-) R$ ' + parseFloat(totalcompra).toFixed(2) + '</b></font></td>';
                    linha += "</tr>";


                    linha += '</table></td></tr>';
                }
                // else if (response[i]['Tipo'] === 'TICKET') {
                //     linha += '<tr>';
                //     linha += '<td width="5%" style="padding: 2px"></td>';
                //     linha += '<td width="65%" style="padding: 2px"><font size="2">VALOR DO TICKET</font></td>';
                //     linha += '<td width="30%" align="right" style="padding: 2px"><font size="2">(-)R$ ' + parseFloat(response[i]['vrTotal']).toFixed(2) + '</font></td>';
                //     linha += '</tr>';
                //     totalGeral += parseFloat(response[i]['vrTotal']);
                // }
                else if (response[i]['Tipo'] === 'DEPOSITO') {
                    if ($("#opt1").is(':checked')) {
                        linha += '<tr>';
                        linha += '<td width="5%" style="padding: 2px"></td>';
                        linha += '<td width="65%" style="padding: 2px"><font size="2">VALOR DO DEPÓSITO</font></td>';
                        linha += '<td width="30%" align="right" style="padding: 2px"><font size="2">(+) R$ ' + parseFloat(response[i]['vrTotal']).toFixed(2) + '</font></td>';
                        linha += '</tr>';
                        totalGeral -= parseFloat(response[i]['vrTotal']);
                    }
                }
            }
            linha += '<tr><td>&nbsp;</td></tr>';

            //Saldo Anterior
            linha += '<tr bgcolor="#666666">';
            linha += '<td colspan="2"><font size="2" color="#FFFFFF"><b>SALDO ANTERIOR:</b></font></td>';
            linha += '<td align="right" style="padding: 2px"><font size="2" color="#FFFFFF"><b>R$ ' + parseFloat($("#saldoAnterior").val()).toFixed(2) + '</b></font></td>';
            linha += '</tr>';


            linha += '<tr bgcolor="#666666">';
            linha += '<td colspan="2"><font size="2" color="#FFFFFF"><b>CONSUMIDO NO PERIODO: </b></font></td>';
            linha += '<td align="right" style="padding: 2px"><font size="2" color="#FFFFFF"><b>R$ ' + parseFloat(totalGeral * -1).toFixed(2) + '</b></font></td>';
            linha += '</tr>';

            linha += '<tr bgcolor="#DCDCDC"><td colspan="2"><font size="2" color="red"><b>Desconto:</b></font></td>';
            linha += '<td align="right"><font size="2" color="red"><b>(-) R$ ' + parseFloat(totalDesconto).toFixed(2) + '</b></font></td></tr>';

            linha += '<tr bgcolor="#666666"><td colspan="2"><font size="2" color="#FFFFFF"><b>Acréscimo:</b></font></td>';
            linha += '<td align="right"><font size="2" color="#FFFFFF"><b>(+) R$ ' + parseFloat(totalAcrescimo).toFixed(2) + '</b></font></td></tr>';

            //Total
            let totalLinha = parseFloat(totalGeral) + parseFloat(totalAcrescimo) + parseFloat(totalDesconto);
            //Saldo Atual
            linha += '<tr bgcolor="#666666">';
            linha += '<td colspan="2"><font size="2" color="#FFFFFF"><b>SALDO FINAL:</b></font></td>';
            linha += '<td align="right" style="padding: 2px"><font size="2" color="#FFFFFF"><b>R$ ' + (parseFloat(totalLinha * -1) + parseFloat($("#saldoAnterior").val())).toFixed(2) + '</b></font></td>';
            linha += '</tr>';
            $(linha).appendTo($("#tableContaAssinada"));


            //Lista de Produtos


            var linhaPrd = '';
            var data = {action: 'getProdutosExtrato', idCliente: id, de: $('#de').val(), ate: $('#ate').val()};
            $.post('relatorios/resources/php/email.php', data, function (response) {

                $("#infosaldoAnterior").html('<span>Saldo Anterior: R$ </span> ' + parseFloat($("#saldoAnterior").val()).toFixed(2) + '');

                var produtos = response;
                var vrTotal = 0;
                for (var i = 0; i < produtos.length; i++) {
                    vrTotal += parseFloat(produtos[i]['vrTotal']);
                    // console.log('produto' + i + ' - ', produtos[i]);
                    linhaPrd += '<tr>';
                    linhaPrd += '<td>' + produtos[i]['stProdutoAbreviado'] + '</td>';
                    linhaPrd += '<td>' + produtos[i]['nrQuantidade'] + ' ' + produtos[i]['stMedida'] + '</td>';
                    linhaPrd += '<td>R$ ' + parseFloat(produtos[i]['vrUnitario']).toFixed(2) + '</td>';
                    linhaPrd += '<td align="right" style="padding: 2px">R$ ' + parseFloat(produtos[i]['vrTotal']).toFixed(2) + '</td>';
                    linhaPrd += "</tr>";
                }
                linhaPrd += '<tr> </tr>';
                linhaPrd += '<tr bgcolor="#666666">';
                linhaPrd += '<td colspan="3"><font size="2" color="#FFFFFF"><b>SubTotal:</b></font></td>';
                linhaPrd += '<td align="right"><font size="2" color="#FFFFFF"><b>R$ ' + parseFloat(vrTotal).toFixed(2) + '</b></font></td></tr>';

                linhaPrd += '<tr bgcolor="#DCDCDC"><td colspan="3"><font size="2" color="red"><b>Desconto:</b></font></td>';
                linhaPrd += '<td align="right"><font size="2" color="red"><b>(-) R$ ' + parseFloat(totalDesconto).toFixed(2) + '</b></font></td></tr>';

                linhaPrd += '<tr bgcolor="#666666"><td colspan="3"><font size="2" color="#FFFFFF"><b>Acréscimo:</b></font></td>';
                linhaPrd += '<td align="right"><font size="2" color="#FFFFFF"><b>(+) R$ ' + parseFloat(totalAcrescimo).toFixed(2) + '</b></font></td></tr>';


                // linhaPrd += '<tr bgcolor="#666666">';
                // linhaPrd += '<td colspan="3"><font size="2" color="#FFFFFF"><b>Saldo Anterior:</b></font></td>';
                // linhaPrd += '<td align="right"><font size="2" color="#FFFFFF"><b>R$ ' + parseFloat($("#saldoAnterior").val()).toFixed(2) + '</b></font></td></tr>';


                linhaPrd += '<tr bgcolor="#666666"><td colspan="3"><font size="2" color="#FFFFFF"><b>TOTAL PRODUTOS:</b></font></td>';
                let total = parseFloat(vrTotal) + parseFloat(totalAcrescimo) + parseFloat(totalDesconto);
                linhaPrd += '<td align="right"><font size="2" color="#FFFFFF"><b>R$ ' + parseFloat(total).toFixed(2) + '</b></font></td>';
                linhaPrd += '</tr>';

                console.log("Total: ", vrTotal)
                console.log("Desconto: ", totalDesconto)


                $(linhaPrd).appendTo($("#tabelaProdutos"));
            });
        }
        linhaBtn = '';
        linhaBtn += '<button type="button" name="button" class="btn btn-primary" ';
        linhaBtn += 'onclick="NewWindow(' + "'relatorios/versaoImpressao.php','versaoImpressao','full','full','yes','center'" + '); return false;"';
        linhaBtn += 'style="display:inline-block; margin:5px">Versão para Impressão</button>';
        linhaBtn += '<a class="btn btn-primary" style="display:inline-block; color:white; margin:5px" href="relatorios/pdf/extrato_clientes.php?idcliente=' + id + '&data_inicial=' + $('#de').val() + '&data_final=' + $('#ate').val() + '&full=' + $('#opt1').is(':checked') + '" target="_blank">';
        linhaBtn += 'EXPORTAR PARA PDF</a>';
        linhaBtn += '<button class="btn btn-primary" style="display:inline-block; margin:5px" onclick="enviarExtrato(' + "'" + id + "'" + ')">Enviar por Email</button>';
        $(linhaBtn).appendTo($('#btnRelatorio'));

        $("body").removeClass("loading");
    });
}

function voltar() {
    $("#filtroTr").removeAttr('hidden');
    $("#clientTable").removeAttr('hidden');
    $("#extratoTr").attr('hidden', 'hidden');
    $("#resultExtrato").attr('hidden', 'hidden');
    $("#tabelaProdutos").html('');
    $('#btnRelatorio').html('');
    $("#tableContaAssinada").html('');
}
