document.addEventListener("DOMContentLoaded", function () {
    $.post('servicos/resources/functions.php', {action: 'getEquipamentos'}, function (response) {
        if (response) {
            var linha = '';
            for (var i = 0; i < response.length; i++) {
                linha += '<li>';
                linha += '<div class="checkbox" style="font-size: 14px;line-height: 1.5em;">';
                linha += '<label>';
                linha += '<input id="equip' + response[i]['id'] + '" type="checkbox" checked>' + response[i]['serial'];
                linha += '</label>';
                linha += '</div>';
                linha += '</li>';
            }
            $(linha).appendTo($('#listaEquip'));
        }
    });
    toastr.options = {"positionClass": "toast-bottom-right"};
    var page = $("#page").val();
    $(document).ready(function () {
        $('.data').datepicker({
            format: 'dd/mm/yyyy',
            language: 'pt-BR',
            autoclose: true
        });
    });
    var dates = currentDate();
    switch (page) {
        case 'exportSat':
            $("#de").mask('00/00/0000');
            $("#ate").mask('00/00/0000');
            $('#de').val(dates[0]);
            $('#ate').val(dates[1]);
            break;
    }
});

function currentDate() {
    var d = new Date();
    var day = d.getDate();
    var month = d.getMonth() + 1;
    if (day < 10) {
        day = '0' + day
    }
    ;
    if (month < 10) {
        month = '0' + month
    }
    ;
    var de = '01/' + month + '/' + d.getFullYear();
    var para = day + '/' + month + '/' + d.getFullYear();
    return [de, para];
}

function pegarXML() {
    $('body').addClass('loading');
    var de = $('#de').val();
    var ate = $('#ate').val();
    var equips = '';
    $('input[id*="equip"]').each(function () {
        if ($(this).is(':checked')) {
            var id = $(this).attr('id');
            id = id.replace('equip', '');
            equips += id + ',';
        }
    });
    if (equips.length == 0) {
        $('body').removeClass('loading');
        swal("Erro!", "É necessário escolher no mínimo um equipamento.", "error");
        return false;
    }
    var data = {action: 'pegarXML', de: de, ate: ate, equipamentos: equips};
    $.post('servicos/resources/functions.php', data, function (response) {
        $('body').removeClass('loading');
        if (response['status']) {
            location.href = 'servicos/resources/xml.zip';
            swal("Sucesso!", "O arquivo foi gerado e será baixado em instantes. Por favor, não saia da página.", "success");
        } else {
            toastr.error('Erro ao gerar arquivo XML.');
        }
    });
}

function inserirCEST() {
    var data = {action: 'inserirCEST'};
    $.post('servicos/resources/functions.php', data, function (response) {
        if (response['status']) {
            toastr.success('CESTs inseridos com Sucesso');
            setTimeout(function () {
                location.reload();
            }, 1200);
        } else {
            toastr.error('Erro ao inserir CESTs.');
        }
    });
}
