<?php

namespace App\Entities\Nati\ExportProductsScale;

use App\Entities\Nati\ExportProductsScale\FileGenerator;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;

class FileGeneratorMGV7 implements FileGenerator
{
    protected $productsIds;
    private $products;

    protected function setProductsIds($productsIds)
    {
        $this->productsIds = $productsIds;
    }
    private function setProducts($products)
    {
        $this->products = $products;
    }


    public function generateItensFile($productsIds, $generateAdditionalInformationFile = false)
    {
        $this->setProductsIds($productsIds);

        $file = $this->formatItensFile();

        $response = $this->saveFile("ITENSMGV.TXT", $file);

        if($generateAdditionalInformationFile) $this->generateAdditionalInformationFile();

        return $response;
    }

    public function formatItensFile()
    {
        //DEPARTAMENTO TAMANHAO 2 PADRAO 01
        $dd = '01';

        //DESRCRICAO LINHA 2 TAMANHO 25
        $desc2 = '                         ';

        //COD INFO EXTRA 6
        $codInfoExtra = '000000';

        //COD IMAGEM TAMANHO 4  PADRAO 00000
        $codImagem = '0000';

        //COD INFO NUTRICIONAL TAMANHO 6 PADRAO 000000
        $codInfoNutricional = '000000';

        //DATA VALIDADE E EMBALAGEM 1 -> IMPRIME | 0 -> NAO IMPRIME CADA
        $datas = '00';

        //COD FORNECEDOR TAMANHO 4, LOTE TAMANHO 12, EAN13 TAMANHO 11, VERSAO PRECO TAMANHO 1, PADRAO VAZIO

        //SOM TAMANHO FRACIONADOR EXTRA1 E 2, COD CONSERVACAO TAMANHO 4 PADRAO 0000
        $codDiversos = '0000000000000001            000000000000000000000000';

        //COD EAN13 FORNECEDOR TAMANHO 12 PADRAO VAZIO

        //PERCENTUAL GLACIAMENTO TAMANHO 6 PADRAO 000000

        //DEPARTAMENTO ASSOCIADO 2 BITS POR DEPARTAMENTO COM | NO COMEÇO E FIM DA STRING CASO HOUVER DEPARTAMENTO

        //DESCRITIVO 3ª E 4ª LINHA TAMANHO 35 CADA PARDAO VAZIO

        //CAMPO EXTRA 3 E 4 E CODIGO MIDIA TAMANHO 6 PADRAO 000000

        //PRECO PROMOCIONAL TAMANHO 6 SEM PONTOU OU VIRGULA PARDAO VAZIO
        $codDiversos2 = '            000000                                                                      000000000000000000      ';

        //BALANCA SOLICITA FORNECEDOR 0 -> NAO | 1 -> SIM PADDRAO 1

        //COD FORNECEDOR ASSOCIADO TAMANHO 6 POR FORNECEDOR | NO COMECO E FIM DA STRING CASO HOUVER FORNECEDOR

        //BALANCA SOLICITA TARA 0 -> NAO | 1 -> SIM PADRAO 1

        //BALANCA SEM ITEM ATIVO TAMANHO 2 POR FORNECEDOR | NO COMECO E FIM DA STRING CASO HOUVER BALANCA
        $solicitacoes = '11';

        //FECHAR COM \R\N
        $fecha = "\r\n";

        $products = $this->getProducts();
        $file = '';
        foreach($products as $item)
        {
//            $nutritionalInformation = null;
            $codInfoNutricional = '000000';
            $codInfoExtra = '000000';
            $rowFile = '';
            $product = json_decode(json_encode($item), true);

            $rowFile .= $dd;


            if (strlen($product['idCodigo']) < 6) {
                $product['idCodigo'] = str_pad($product['idCodigo'], 6, '0', STR_PAD_LEFT);
            }

            //INFORMAÇÕES NUTRICIONAIS TAMANHO 6 PADRAO 000000
            $nutritionalInformation = $this->getNutritionalInformation($product['idProduto']);
            if($nutritionalInformation) $codInfoNutricional = $product['idCodigo'];

            $additionalInformation = $product['stDescricao'];
            if($additionalInformation) $codInfoExtra = $product['idCodigo'];

            //TIPO TAMANHO 1  0 -> FRACIONADO | 1 -> INTEIRO
            if($product['flFracionado'] == 1) {
                $rowFile .= '0';
            } else {
                $rowFile .= '1';
            }

            //CODIGO DO PRODUTO TAMANHO 6
            $rowFile .= $product['idCodigo'];

            //PRECO TAMANHO 6 SEM VIRGULA OU PONTO 2 CASAS DECIMAIS
            $product['vrUnitario'] = number_format($product['vrUnitario'], 2, "", "");
            if (strlen($product['vrUnitario']) > 6) {
                $product['vrUnitario'] = substr($product['vrUnitario'], 0, 6);
            }
            if (strlen($product['vrUnitario']) < 6) {
                $product['vrUnitario'] = str_pad($product['vrUnitario'], 6, '0', STR_PAD_LEFT);
            }
            $rowFile .= $product['vrUnitario'];

            //VALIDADE TAMANHO 3
            if (strlen($product['nrValidade']) > 3) {
                $product['nrValidade'] = substr($product['nrValidade'], 0, 3);
            }
            if (strlen($product['nrValidade']) < 3) {
                $product['nrValidade'] = str_pad($product['nrValidade'], 3, '0', STR_PAD_LEFT);
                if ($product['nrValidade'] != 0) {
                    $datas = '11';
                }
                else{
                    $datas = '01';
                }
            }
            $rowFile .= $product['nrValidade'];

            //DESRCRICAO LINHA 1 TAMANHO 25
            $product['stProduto'] = strtoupper(utf8_encode($product['stProduto']));
            if (strlen($product['stProduto']) > 25) {
                $product['stProduto'] = substr($product['stProduto'], 0, 25);
            }
            if (strlen($product['stProduto']) < 25) {
                $product['stProduto'] = str_pad($product['stProduto'], 25, ' ', STR_PAD_RIGHT);
            }
//            $codInfoNutricional = str_pad($product['idProduto'], 6, "0", STR_PAD_LEFT);
            $rowFile .= $product['stProduto'].$desc2.$codInfoExtra.$codImagem;
            $rowFile .= $codInfoNutricional.$datas.$codDiversos.$codDiversos2.$solicitacoes.$fecha;

            $file .= $rowFile;
        }
        return $file;
    }

    public function saveFile($nameFile, $file)
    {
        $erro = false;
        $path = Storage::path($nameFile);
        @unlink($path, $nameFile);
        $fopen = @fopen($path, "w") or $erro = true;
        @fwrite($fopen, $file) or $erro = true;
        @fclose($fopen) or $erro = true;
    }

    public function getProducts()
    {
        $productsIds = $this->productsIds->all();
        foreach($productsIds as $item) {
            $arr[] = $item['idProduto'];
        }
        $productsIds = implode(',', $arr);
        $query = "SELECT P.idProduto, M.idMedida, M.flFracionado, C.idCodigo, P.stProduto, P.nrValidade, P.stDescricao,
                    CASE WHEN P.flPromocao = '1' AND GETDATE() BETWEEN P.dtInicioPromocao AND P.dtFimPromocao THEN P.vrUnitarioPromocao ELSE P.vrUnitario END AS vrUnitario
                    FROM prd_Produtos P
                    INNER JOIN prd_Codigos C ON P.idProduto = C.idProduto
                    INNER JOIN prd_Medidas M ON P.idMedida = M.idMedida
                    WHERE P.flAtivo = '1' AND LEN(C.idCodigo) <= 6 AND p.idProduto in ($productsIds)
                    ORDER BY P.stProduto";
        $products = DB::select($query);
//        $this->setProducts($products->all());
        return $products;
    }

    public function generateNutritionalInformationFile()
    {
        $file = $this->formatNutritionalInformationFile();

        $response = $this->saveFile("INFNUTRI.TXT", $file);
    }

    public function formatNutritionalInformationFile()
    {
        $nutritionalInformationsFile = '';

        foreach($this->productsIds as $productId)
        {
            $nutritionalInformations = $this->getNutritionalInformation($productId['idProduto']);
            foreach($nutritionalInformations as $item) {
                if($item['stTipo'] == 'rdc429') {
                    $nutritionalInformationsFile .= $this->generateRdc429($item);
                }
            }
        }
        return $nutritionalInformationsFile;
    }
    public function generateRdc360($nutritionalInformations)
    {
        $codNutritional = str_pad($nutritionalInformations[0]['idCodigo'], 6, "0", STR_PAD_LEFT);
        $nrQuantidade = str_pad($nutritionalInformations[0]['nrQuantidade'], 4, "0", STR_PAD_LEFT);
        $nrUnidadePorcao = $nutritionalInformations[0]['nrUnidadePorcao'];
        $nrParteInteiraMedidaCaseira = str_pad($nutritionalInformations[0]['nrParteInteiraMedidaCaseira'], 2, "0", STR_PAD_LEFT);
        $nrParteDecimalMedidaCaseira = $nutritionalInformations[0]['nrParteDecimalMedidaCaseira'];
        $nrMedidaCaseira = str_pad($nutritionalInformations[0]['nrMedidaCaseira'], 2, "0", STR_PAD_LEFT);
        $nrValorEnergetico = str_pad($nutritionalInformations[0]['nrValorEnergetico'], 4, "0", STR_PAD_LEFT);
        $nrCarboidratos = str_pad(number_format($nutritionalInformations[0]['nrCarboidratos'], 0, "", ""), 3, "0", STR_PAD_LEFT);
        $nrProteinas = str_pad(number_format($nutritionalInformations[0]['nrProteinas'], 0, "", ""), 3, "0", STR_PAD_LEFT);
        $nrGordurasTotais = str_pad(number_format($nutritionalInformations[0]['nrGordurasTotais'], 0, "", ""), 3, "0", STR_PAD_LEFT);
        $nrGordurasSaturadas = str_pad(number_format($nutritionalInformations[0]['nrGordurasSaturadas'], 0, "", ""), 3, "0", STR_PAD_LEFT);
        $nrGordurasTrans = str_pad(number_format($nutritionalInformations[0]['nrGordurasTrans'], 0, "", ""), 3, "0", STR_PAD_LEFT);
        $nrFibraAlimentar = str_pad(number_format($nutritionalInformations[0]['nrFibraAlimentar'], 0, "", ""), 3, "0", STR_PAD_LEFT);
        $nrSodio = str_pad(number_format($nutritionalInformations[0]['nrSodio'], 0, "", ""), 5, "0", STR_PAD_LEFT);
        return "N".$codNutritional.$nrQuantidade.$nrUnidadePorcao.$nrParteInteiraMedidaCaseira.$nrParteDecimalMedidaCaseira.$nrMedidaCaseira.$nrValorEnergetico.$nrCarboidratos.$nrProteinas.$nrGordurasTotais.$nrGordurasSaturadas.$nrGordurasTrans.$nrFibraAlimentar.$nrSodio."0\r\n";
    }
    public function generateRdc429($nutritionalInformations)
    {
        $codNutritional = str_pad($nutritionalInformations['idCodigo'], 6, "0", STR_PAD_LEFT);
        $nrQuantidade = str_pad($nutritionalInformations['nrQuantidade'], 3, "0", STR_PAD_LEFT);
        $nrUnidadePorcao = $nutritionalInformations['nrUnidadePorcao'];
        $nrParteInteiraMedidaCaseira = str_pad($nutritionalInformations['nrParteInteiraMedidaCaseira'], 2, "0", STR_PAD_LEFT);
        $nrParteDecimalMedidaCaseira = $nutritionalInformations['nrParteDecimalMedidaCaseira'];
        $nrMedidaCaseira = str_pad($nutritionalInformations['nrMedidaCaseira'], 2, "0", STR_PAD_LEFT);
        $nrValorEnergetico = str_pad($nutritionalInformations['nrValorEnergetico'], 4, "0", STR_PAD_LEFT);
        $nrCarboidratos = str_pad(number_format($nutritionalInformations['nrCarboidratos'], 1, "", ""), 4, "0", STR_PAD_LEFT);
        $nrProteinas = str_pad(number_format($nutritionalInformations['nrProteinas'], 1, "", ""), 3, "0", STR_PAD_LEFT);
        $nrGordurasTotais = str_pad(number_format($nutritionalInformations['nrGordurasTotais'], 1, "", ""), 3, "0", STR_PAD_LEFT);
        $nrGordurasSaturadas = str_pad(number_format($nutritionalInformations['nrGordurasSaturadas'], 1, "", ""), 3, "0", STR_PAD_LEFT);
        $nrGordurasTrans = str_pad(number_format($nutritionalInformations['nrGordurasTrans'], 1, "", ""), 3, "0", STR_PAD_LEFT);
        $nrFibraAlimentar = str_pad(number_format($nutritionalInformations['nrFibraAlimentar'], 0, "", ""), 3, "0", STR_PAD_LEFT);
        $nrSodio = str_pad(number_format($nutritionalInformations['nrSodio'], 0, "", ""), 5, "0", STR_PAD_LEFT);
        $nrPorcoesEmbalagem = str_pad($nutritionalInformations['nrQuantidadePorcoesEmbalagem'], 3, "0", STR_PAD_LEFT);
        $nrAcucaresTotais = str_pad(number_format($nutritionalInformations['nrAcucaresTotais'], 0, "", ""), 3, "0", STR_PAD_LEFT);
        $nrAcucaresAdicionados = str_pad(number_format($nutritionalInformations['nrAcucaresAdicionados'], 0, "", ""), 3, "0", STR_PAD_LEFT);
        $flAltoAcucarAdicionado = $nutritionalInformations['flAltoAcucarAdicionado'];
        $flAltoGorduraSaturada = $nutritionalInformations['flAltoGorduraSaturada'];
        $flAltoSodio = $nutritionalInformations['flAltoSodio'];
        $nrLactose = str_pad(number_format($nutritionalInformations['nrLactose'], 0, "", ""), 5, "0", STR_PAD_LEFT);
        $nrGalactose = str_pad(number_format($nutritionalInformations['nrGalactose'], 0, "", ""), 5, "0", STR_PAD_LEFT);
        return "N".$codNutritional."000000000000000000000000000000000000000000|".'0'.$nrPorcoesEmbalagem.$nrQuantidade.$nrUnidadePorcao.$nrParteInteiraMedidaCaseira.$nrParteDecimalMedidaCaseira.$nrMedidaCaseira.$nrValorEnergetico.$nrCarboidratos.$nrAcucaresTotais.$nrAcucaresAdicionados.$nrProteinas.$nrGordurasTotais.$nrGordurasSaturadas.$nrGordurasTrans.$nrFibraAlimentar.$nrSodio.$flAltoAcucarAdicionado.$flAltoGorduraSaturada.$flAltoSodio.$nrLactose.$nrGalactose."1\r\n";
    }

    public function getNutritionalInformation($idProduto = null)
    {
        $nutritionalInformations = DB::select("select * from prd_TabelasNutricionais as n
                                                        join prd_codigos c on n.idproduto = c.idproduto
                                                        where n.idProduto = $idProduto");
        return $nutritionalInformations = json_decode(json_encode($nutritionalInformations), true);
    }

    public function generateAdditionalInformationFile()
    {
        $file = $this->formatAdditionalInformationFile();

        $response = $this->saveFile("TXINFO.TXT", $file);
    }

    public function formatAdditionalInformationFile()
    {
        $products = $this->getProducts();
        $file = '';
        $fecha = "\r\n";

        foreach($products as $item) {
            $product = json_decode(json_encode($item), true);
            if (strlen($product['stDescricao']) > 0) {
                if (strlen($product['idCodigo']) < 6) {
                    $product['idCodigo'] = str_pad($product['idCodigo'], 6, '0', STR_PAD_LEFT);
                }
                $file .= $product['idCodigo'];
                $infoAdditional = '';
                $infoAdditional = str_pad($infoAdditional, 100, " ", STR_PAD_RIGHT);
                $product = json_decode(json_encode($product), true);
                $product['stDescricao'] = $this->cleanString($product['stDescricao']);

                $file .= $infoAdditional . $product['stDescricao'] . $fecha;
            }
        }
        return $file;
    }

    public function cleanString($text) {
        $utf8 = array(
            '/[áàâãªä]/u'   =>   'a',
            '/[ÁÀÂÃÄ]/u'    =>   'A',
            '/[ÍÌÎÏ]/u'     =>   'I',
            '/[íìîï]/u'     =>   'i',
            '/[éèêë]/u'     =>   'e',
            '/[ÉÈÊË]/u'     =>   'E',
            '/[óòôõºö]/u'   =>   'o',
            '/[ÓÒÔÕÖ]/u'    =>   'O',
            '/[úùûü]/u'     =>   'u',
            '/[ÚÙÛÜ]/u'     =>   'U',
            '/ç/'           =>   'c',
            '/Ç/'           =>   'C',
            '/ñ/'           =>   'n',
            '/Ñ/'           =>   'N',
            '/–/'           =>   '-', // UTF-8 hyphen to "normal" hyphen
            '/[’‘‹›‚]/u'    =>   ' ', // Literally a single quote
            '/[“”«»„]/u'    =>   ' ', // Double quote
            '/ /'           =>   ' ', // nonbreaking space (equiv. to 0x160)
        );
        return preg_replace(array_keys($utf8), array_values($utf8), $text);
    }
}
