<?php

namespace App\Entities;

use App\Traits\HasCompositePrimaryKey;
use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

class ReceiptForm extends Model implements Transformable
{
    use TransformableTrait;
    //    use HasCompositePrimaryKey;

    protected $table = 'cx_FichaPagamentos';
    protected $primaryKey = ['idFicha', 'idVenda', 'idAbertura'];

    public $timestamps = false;
    public $incrementing = false;

    protected $hidden = [

    ];

    protected $fillable = [
        'idFicha',
        'idVenda',
        'idAbertura',
        'idFormaPagamento',
        'vrFormaPagamento',
        'dtdata',
        'flTroco',
        'flAtivo',
        'dtAlteracao',
        'idBanco',
        'nrCheque',
        'nrAgenciaCheque',
        'nrContaCheque',
        'dtDepositoCheque',
        'flVaucher',
        'formaPagamento',
        'flConferido'
    ];

    protected $casts = [
        'flTroco' => 'boolean',
        'flVaucher' => 'boolean',
        'flAtivo' => 'boolean',
        'flConferido' => 'boolean',
        'vrFormaPagamento' => 'float'
    ];

    public function formaPagamento()
    {
        return $this->belongsTo(PaymentMethod::class, 'idFormaPagamento', 'idFormaPagamento');
    }

    public function venda(){
        return $this->hasMany(Sale::class, ['idVenda', 'idAbertura'], ['idVenda', 'idAbertura']);
    }
}
