<?php

namespace App\Entities;

use App\Traits\HasCompositePrimaryKey;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

class ReceiptFormTemp extends Model implements Transformable
{
    use TransformableTrait;
    //    use HasCompositePrimaryKey;

    protected $table = 'cx_FichaRecebimentos_Temp';
    protected $primaryKey = ['idFicha', 'idVenda', 'idAbertura'];
    protected $casts = ['flTroco' => 'boolean'];

    public $timestamps = false;
    public $incrementing = false;

    protected $fillable = [
        'idFicha',
        'idVenda',
        'idAbertura',
        'idFormaPagamento',
        'vrFormaPagamento',
        'dtdata',
        'flTroco',
        'flAtivo',
        'dtAlteracao',
        'idBanco',
        'nrCheque',
        'nrAgenciaCheque',
        'nrContraCheque',
        'dtDepositoCheque',
        'flVaucher',
        'dtAlteracao'
    ];


    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);

        $this->flTroco = false;
        $this->idBanco = 0;
        $this->nrCheque = 0;
        $this->nrAgenciaCheque = 0;
        $this->nrContaCheque = 0;
        $this->dtDepositoCheque=0;
        $this->flVaucher = false;
        $this->flAtivo = true;
        $this->dtdata = Carbon::now();
        $this->dtAlteracao = Carbon::now();
    }

    public static function nextId($idAbertura, $idVenda){
        return ReceiptFormTemp::where(['idAbertura' => $idAbertura, 'idVenda'=> $idVenda])->max('idFicha') + 1;

    }

    public function formaPagamento()
    {
        return $this->hasOne(PaymentMethod::class, 'idFormaPagamento', 'idFormaPagamento');
    }

    public function venda()
    {
        return $this->belongsTo(SaleTemp::class, 'idVenda', 'idVenda');
    }
}
