<?php

namespace App\Entities;

use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

/**
 * Class Entregador.
 *
 * @package namespace App\Entities;
 */
class SalesItensView extends Model implements Transformable
{
    use TransformableTrait;

    protected $table = 'sales_item_list';
    protected $primaryKey = ['idItem','idVenda', 'idAbertura'];
    public $incrementing = false;
    public $timestamps = false;

    protected $casts = [
        'idAbertura' => 'int',
        'idVenda' => 'int',
        'vrTotal' => 'float',
        'flAtivo' => 'bool'
    ];

}
