<?php

namespace App\Http\Controllers;

use Exception;
use Illuminate\Http\Request;

use App\Http\Requests;
use Prettus\Validator\Contracts\ValidatorInterface;
use Prettus\Validator\Exceptions\ValidatorException;
use App\Http\Requests\DesenfilaConfigCreateRequest;
use App\Http\Requests\DesenfilaConfigUpdateRequest;
use App\Repositories\DesenfilaConfigRepository;
use App\Validators\DesenfilaConfigValidator;
use Ramsey\Uuid\Uuid;

/**
 * Class DesenfilaConfigsController.
 *
 * @package namespace App\Http\Controllers;
 */
class DesenfilaConfigsController extends Controller
{
    /**
     * @var DesenfilaConfigsRepository
     */
    protected $repository;

    /**
     * @var DesenfilaConfigValidator
     */
    protected $validator;

    /**
     * DesenfilaConfigsController constructor.
     *
     * @param DesenfilaConfigRepository $repository
     * @param DesenfilaConfigValidator $validator
     */
    public function __construct(DesenfilaConfigRepository $repository, DesenfilaConfigValidator $validator)
    {
        $this->repository = $repository;
        $this->validator = $validator;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function index()
    {
        try {
            $desenfilaConfigs = $this->repository->all();
            return response()->json($desenfilaConfigs);

        } catch (Exception $exception) {
            return response()->json([
                'erro' => true,
                'message' => $exception->getMessage()
            ], 404);
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param DesenfilaConfigCreateRequest $request
     *
     * @return \Illuminate\Http\JsonResponse
     *
     * @throws \Prettus\Validator\Exceptions\ValidatorException
     */
    public function store(DesenfilaConfigCreateRequest $request)
    {
        try {

            $this->validator->with($request->all())->passesOrFail(ValidatorInterface::RULE_CREATE);
//            $request['id'] = (string)Uuid::generate(4);
            $desenfilaConfig = $this->repository->create($request->all());

            $response = [
                'message' => 'DesenfilaConfig created.',
                'data' => $desenfilaConfig->toArray(),
            ];


            return response()->json($response);

        } catch (ValidatorException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessageBag()
            ]);

        }
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function show($id)
    {
        $desenfilaConfig = $this->repository->find($id);


        return response()->json($desenfilaConfig);

    }

    /**
     * Update the specified resource in storage.
     *
     * @param DesenfilaConfigUpdateRequest $request
     * @param string $id
     *
     * @return \Illuminate\Http\JsonResponse
     *
     * @throws \Prettus\Validator\Exceptions\ValidatorException
     */
    public function update(DesenfilaConfigUpdateRequest $request, $id)
    {
        try {

            $this->validator->with($request->all())->passesOrFail(ValidatorInterface::RULE_UPDATE);

            $desenfilaConfig = $this->repository->update($request->all(), $id);

            $response = [
                'message' => 'DesenfilaConfig updated.',
                'data' => $desenfilaConfig->toArray(),
            ];


                return response()->json($response);

        } catch (ValidatorException $e) {


                return response()->json([
                    'error' => true,
                    'message' => $e->getMessageBag()
                ]);
        }
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function destroy($id)
    {
        $deleted = $this->repository->delete($id);
            return response()->json([
                'message' => 'DesenfilaConfig deleted.',
                'deleted' => $deleted,
            ]);

    }
}
