<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Http\Requests\Nati\ImpressoraCreateRequest;
use App\Http\Requests\Nati\ImpressoraUpdateRequest;
use App\Services\Nati\ImpressorasService;
use Illuminate\Contracts\Container\BindingResolutionException;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use Prettus\Validator\Exceptions\ValidatorException;

class ImpressoraController extends Controller
{

    protected $service;

    public function __construct(ImpressorasService $service)
    {
        $this->service = $service;
    }

    /**
     * Display a listing of the resource.
     *
     * @return JsonResponse
     */
    public function index()
    {
        try {
            $impressorass = $this->service->all();

            return response()->json($impressorass);
        } catch (\Exception $exception) {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 404);
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param ImpressoraCreateRequest $request
     *
     * @return JsonResponse
     */
    public function store(ImpressoraCreateRequest $request)
    {
        try {
            $impressoras = $this->service->create($request->all());

            $impressora = [
                'message' => 'Impressora created.',
                'data' => $impressoras->toArray(),
            ];
            return response()->json($impressora, 201);

        } catch (ModelNotFoundException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessageBag()
            ], 400);
        } catch (ValidatorException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessageBag()
            ], 404);
        }
    }


    /**
     * Display the specified resource.
     *
     * @param int $id
     *
     * @return JsonResponse
     */
    public function show($id)
    {
        try {
            $impressoras = $this->service->getById($id);

            return response()->json($impressoras);
        } catch (\Exception $exception) {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 404);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param ImpressoraUpdateRequest $request
     * @param string $id
     *
     * @return JsonResponse
     */
    public function update(ImpressoraUpdateRequest $request, $id)
    {
        try {
            $impressora = $this->service->update($request->all(), $id);
            return response()->json([
                'message' => 'Impressora Update',
                'data' => $impressora
            ], 201);


        } catch (ModelNotFoundException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 400);

        } catch (ValidatorException $e) {

            return response()->json([
                'error' => true,
                'message' => $e->getMessageBag()
            ], 404);
        } catch (\Exception $e) {

            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 500);
        }
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param string $id
     *
     * @return JsonResponse
     * @throws BindingResolutionException
     */
    public function destroy($id)
    {
        try {
            $this->service->delete($id);
            return response()->json(['message' => 'Impressora deleted']);
        } catch (ModelNotFoundException $e) {
            return response()->json(['error' => true, 'message' => $e->getMessage()], 404);
        } catch (\Exception $e) {
            return response()->json(['error' => true, 'message' => $e->getMessage()], 500);
        }
    }
}
