<?php

namespace App\Http\Controllers;

use App\Entities\Master;
use App\Http\Controllers\Controller;
use App\Reports\Commission;
//use App\Reports\SalesByCustomer;
use Carbon\Carbon;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class MyReportController extends Controller
{
    public function vendas()
    {
        $data = [
            'company' => Master::first(),
            'version' => '6.0.2.4'
        ];
//        $query = "SELECT m.stMedida, m.flFracionado, i.idCodProduto, p.nrNcm ,i.idProduto, p.stProduto, SUM(i.nrQuantidade) as nrQuantidade, SUM(i.vrTotal - i.vrDesconto) as vrTotal
//                    ,  X.stSetor
//                    FROM (SELECT * FROM cx_Itens UNION SELECT * FROM cx_Itens_Temp) i
//                    INNER JOIN prd_Produtos p ON i.idProduto = p.idProduto
//                    INNER JOIN prd_Medidas m ON p.idMedida = m.idMedida
//                    INNER JOIN cx_Gerenciador g ON i.idAbertura = g.idAbertura
//                    INNER JOIN prd_Setores X ON P.idSetor = X.idSetor
//                    WHERE i.flAtivo = '1' AND i.dtData BETWEEN '2020-01-01 00:00:00' AND '2020-10-05 23:59:59'
//                    AND (g.idAbertura IN (1,2,3,4,5,6,7,8)) and p.idSetor in (1,10,11,20,25,30,40,41,60,80,101,102,105,114,115,119,121,133,139,144,155)
//                    GROUP BY i.idCodProduto, p.nrNcm,i.idProduto, p.stProduto, m.stMedida, m.flFracionado,  X.stSetor
//                    ORDER BY nrQuantidade DESC";
//
//        $data['vendas'] =  DB::select($query);

        $report = new Commission;
        $report->run();
        return view("reports.vendas")->with("report", $report);

//        return view('nati.reports.vendas')->with('data', $data);
    }

    public function commission()
    {
        $data = [
            'company' => Master::first(),
            'version' => '6.0.2.4'
        ];

        $report = new Commission;
        $report->run();
        return view('commission')->with('report', $report)->with('data', $data);
    }

    public function sales()
    {
        try {
            $query = "SELECT m.stMedida, m.flFracionado, i.idCodProduto, p.nrNcm ,i.idProduto, p.stProduto, SUM(i.nrQuantidade) as nrQuantidade, SUM(i.vrTotal - i.vrDesconto) as vrTotal
                    ,  X.stSetor
                    FROM (SELECT * FROM cx_Itens UNION SELECT * FROM cx_Itens_Temp) i
                    INNER JOIN prd_Produtos p ON i.idProduto = p.idProduto
                    INNER JOIN prd_Medidas m ON p.idMedida = m.idMedida
                    INNER JOIN cx_Gerenciador g ON i.idAbertura = g.idAbertura
                    INNER JOIN prd_Setores X ON P.idSetor = X.idSetor
                    WHERE i.flAtivo = '1' AND i.dtData BETWEEN '2020-01-01 00:00:00' AND '2020-10-05 23:59:59'
                    AND (g.idAbertura IN (1,2,3,4,5,6,7,8)) and p.idSetor in (1,10,11,20,25,30,40,41,60,80,101,102,105,114,115,119,121,133,139,144,155)
                    GROUP BY i.idCodProduto, p.nrNcm,i.idProduto, p.stProduto, m.stMedida, m.flFracionado,  X.stSetor
                    ORDER BY nrQuantidade DESC";
            $result = DB::select($query);

            return response()->json($result);

        } catch (Exception $exception) {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 400);
        }
    }

    public function sumary(Request $request)
    {
        $fd = Carbon::createFromFormat('d/m/Y', $request['firstDate'])->toDateString();
        $first_date = $fd . ' 00:00:00';
        $ld = Carbon::createFromFormat('d/m/Y', $request['lastDate'])->toDateString();
        $last_date = $ld . ' 23:59:59';

        $temp = DB::table('cx_vendas_temp')
            ->select(DB::raw("CAST(dtData AS DATE) as date"),
                DB::raw('sum(CASE WHEN flAtivo = 1 THEN vrTotal ELSE 0 END) as vendas'),
                DB::raw('sum(CASE WHEN flAtivo = 0 THEN vrTotal ELSE 0 END) as cancelamentos'),
                DB::raw('sum(vrDesconto) as descontos'))
            ->whereBetween(DB::raw('cast(dtData AS DATE)'), [$first_date, $last_date])
            ->groupBy(DB::raw("CAST(dtData AS DATE)"));

        $vendas = DB::table('cx_vendas')
            ->select(DB::raw("CAST(dtData AS DATE) as date"),
                DB::raw('sum(CASE WHEN flAtivo = 1 THEN vrTotal ELSE 0 END) as vendas'),
                DB::raw('sum(CASE WHEN flAtivo = 0 THEN vrTotal ELSE 0 END) as cancelamentos'),
                DB::raw('sum(vrDesconto) as descontos'))
            ->whereBetween(DB::raw('cast(dtData AS DATE)'), [$first_date, $last_date])
            ->union($temp)
            ->groupBy(DB::raw("CAST(dtData AS DATE)"));

        $result = DB::table(DB::raw("({$vendas->toSql()}) as x"))
            ->select(DB::raw('date'),
                DB::raw('sum(x.vendas) as vendas'),
                DB::raw('sum(x.cancelamentos) as cancelamentos'),
                DB::raw('sum(x.descontos) as descontos'),
                DB::raw('sum(x.vendas - x.cancelamentos - x.descontos) as liquido'))
            ->mergeBindings($vendas)
            ->groupBy('date')
            ->orderBy('date', 'ASC')
            ->get();

        $res = [];
        $totais = [
            'vendas' => $result->sum('vendas'),
            'cancelamentos' => $result->sum('cancelamentos'),
            'descontos' => $result->sum('descontos')
        ];

        foreach ($result as $venda) {

            array_push($res, collect([
                'name' => Carbon::parse($venda->date)->format('d/m'),
                'series' => [
                    ['name' => 'Vendas', 'value' => (float)$venda->vendas],
                    ['name' => 'Cancelamentos', 'value' => (float)$venda->cancelamentos],
                ]
            ]));
        }

        $data['data'] = $res;
        $data['totais'] = $totais;
        $data['table'] = $result;
        return $data;
    }
}
