<?php

namespace App\Observers;

use App\Entities\Nati\FichaTecnica;
use App\Entities\Nati\Product;
use Illuminate\Support\Facades\Cache;

class ProductObserver
{
    /**
     * Handle the product "created" event.
     *
     * @param Product $product
     * @return void
     */
    public function created(Product $product)
    {
        Cache::tags(['ListaProducts'])->flush();
    }

    /**
     * Handle the product "updated" event.
     *
     * @param Product $product
     * @return void
     */
    public function updated(Product $product)
    {
        if ($product->idSetor != $product->getOriginal('idSetor')) {
            FichaTecnica::where('idProduto', $product->idProduto)->update(['idSetor' => $product->idSetor]);
        }
        Cache::tags(['ListaProducts'])->flush();
    }

    /**
     * Handle the product "deleted" event.
     *
     * @param Product $product
     * @return void
     */
    public function deleted(Product $product)
    {
        Cache::tags(['ListaProducts'])->flush();
    }

    /**
     * Handle the product "restored" event.
     *
     * @param Product $product
     * @return void
     */
    public function restored(Product $product)
    {
        Cache::tags(['ListaProducts'])->flush();
    }

    /**
     * Handle the product "force deleted" event.
     *
     * @param Product $product
     * @return void
     */
    public function forceDeleted(Product $product)
    {
        Cache::tags(['ListaProducts'])->flush();
    }
}
