<?php

namespace App\Observers;

use App\Entities\Nati\Sector;
use Illuminate\Support\Facades\Cache;

class SetorObserver
{
    /**
     * Handle the sector "created" event.
     *
     * @param Sector $sector
     * @return void
     */
    public function created(Sector $sector)
    {
        Cache::tags('ListaSetores')->flush();
    }

    /**
     * Handle the sector "updated" event.
     *
     * @param Sector $sector
     * @return void
     */
    public function updated(Sector $sector)
    {
        Cache::tags('ListaSetores')->flush();
    }

    /**
     * Handle the sector "deleted" event.
     *
     * @param Sector $sector
     * @return void
     */
    public function deleted(Sector $sector)
    {
        Cache::tags('ListaSetores')->flush();
    }

    /**
     * Handle the sector "restored" event.
     *
     * @param Sector $sector
     * @return void
     */
    public function restored(Sector $sector)
    {
        Cache::tags('ListaSetores')->flush();
    }

    /**
     * Handle the sector "force deleted" event.
     *
     * @param Sector $sector
     * @return void
     */
    public function forceDeleted(Sector $sector)
    {
        Cache::tags('ListaSetores')->flush();
    }
}
