<?php

namespace App\Repositories;

use Prettus\Repository\Eloquent\BaseRepository;
use Prettus\Repository\Criteria\RequestCriteria;
use App\Repositories\ConfigAdquirenteRepository;
use App\Entities\ConfigAdquirente;
use App\Validators\ConfigAdquirenteValidator;

/**
 * Class ConfigAdquirenteRepositoryEloquent
 * @package namespace App\Repositories;
 */
class ConfigAdquirenteRepositoryEloquent extends BaseRepository implements ConfigAdquirenteRepository
{
    /**
     * Specify Model class name
     *
     * @return string
     */
    public function model()
    {
        return ConfigAdquirente::class;
    }

    /**
    * Specify Validator class name
    *
    * @return mixed
    */
    public function validator()
    {

        return ConfigAdquirenteValidator::class;
    }


    /**
     * Boot up the repository, pushing criteria
     */
    public function boot()
    {
        $this->pushCriteria(app(RequestCriteria::class));
    }
}
