<?php

namespace App\Services\Delivery;

use Illuminate\Support\Facades\DB;
use App\Validators\MobyoConfigValidator;
use App\Repositories\MobyoConfigRepository;
use App\Entities\Delivery\MobyoConfig;
use App\Entities\Mobyo\MobyoPayment;


class MobyoConfigService
{
    private $repository;
    private $validator;

    public function __construct(MobyoConfigValidator $validator, MobyoConfigRepository $repository)
    {
        $this->validator = $validator;
        $this->repository = $repository;
    }

    public function get()
    {
        $mobyoConfigs = MobyoConfig::join('dlv_clientes', 'mobyo_config.idCliente', '=', 'dlv_clientes.idCliente')
                                    ->select('mobyo_config.*', 'dlv_clientes.stCliente')
                                    ->with('payments')
                                    ->get();
        return $mobyoConfigs;
    }

    public function getMobyoConfig($id)
    {
        $mobyoConfig = MobyoConfig::join('dlv_clientes', 'mobyo_config.idCliente', '=', 'dlv_clientes.idCliente')
                                    ->select('mobyo_config.*', 'dlv_clientes.stCliente')
                                    ->where('mobyo_config.id', $id)
                                    ->where('mobyo_config.flAtivo', true)
                                    ->with('payments')
                                    ->get();
        return $mobyoConfig;
    }

    public function update($request, $id)
    {
        $mobyoConfigs = MobyoConfig::find($id);
        // $mobyoConfigs->idMerchant = $request['idMerchant'];
        $mobyoConfigs->flClienteFixo = $request['flClienteFixo'];
        $mobyoConfigs->idCliente = $request['idCliente'];
        $mobyoConfigs->codProdutoGenerico = $request['codProdutoGenerico'];
        $mobyoConfigs->idCaixa = $request['idCaixa'];
        $mobyoConfigs->idUser = $request['idUser'];
        $mobyoConfigs->idDeliveryPadrao = $request['idDeliveryPadrao'];
        $mobyoConfigs->flSalvarClienteObservacao = $request['flSalvarClienteObservacao'];
        $mobyoConfigs->flSalvarTaxaEntrega = $request['flSalvarTaxaEntrega'];
        $mobyoConfigs->flEmitirCupomDelivery = $request['flEmitirCupomDelivery'];
        $mobyoConfigs->flEmitirCupomRemoto = $request['flEmitirCupomRemoto'];
        $mobyoConfigs->flUsarPainelPreparo = $request['flUsarPainelPreparo'];
        $mobyoConfigs->flSalvarVendaAutomaticamente = $request['flSalvarVendaAutomaticamente'];
        $mobyoConfigs->flDespacharPedidoAutomaticamente = $request['flDespacharPedidoAutomaticamente'];
        $mobyoConfigs->flEmitirCFEAutomaticamente = $request['flEmitirCFEAutomaticamente'];
        $mobyoConfigs->flSalvarDesconto = $request['flSalvarDesconto'];
        $mobyoConfigs->flSalvarTaxaServico = $request['flSalvarTaxaServico'];
        $mobyoConfigs->idContaFinanceiro = 19;
        $mobyoConfigs->flAtivo = true;
        $mobyoConfigs->save();

        //PAYMENTS
        foreach($request['payments'] as $key => $value) {
            $mobyoPayments = DB::table('mobyo_payments')
                                ->where('idMobyoConfig', $id)
                                ->where('name', $key)
                                ->update(['idFormaPagamento' => $value]);
        }
    }

    public function delete($id)
    {
        $mobyoConfigs = MobyoConfig::find($id);
        $mobyoConfigs->flAtivo = 0;
        $mobyoConfigs->save();
    }
}

