<?php

/*
|--------------------------------------------------------------------------
| Model Factories
|--------------------------------------------------------------------------
|
| Here you may define all of your model factories. Model factories give
| you a convenient way to create models for testing and seeding your
| database. Just tell the factory how a default model should look.
|
*/

use App\Entities\Nati\Product;
use Illuminate\Database\Eloquent\Factory;
/** @var $factory Factory */
$factory->define(Product::class, function (Faker\Generator $faker) {

    return [
        'idProduto' => Product::max('idProduto') + 1,
        'stProduto' => $faker->text(30),
        'stProdutoAbreviado' => $faker->text(29),
        'stOperador' => $faker->firstName,
        'idCategoria' => 1,
        'idSetor' => "10",
        'idMedida' => "1",
        'idLocalizacao' => $faker->numberBetween(1, 5),
        'idAliquota' => 1,//Aliquota::first(),
        'vrUnitario' => $faker->randomFloat(3, 1, 99),
        'vrCusto' => $faker->randomFloat(3, 1, 99),
        'flComissao' => $faker->boolean(),
        'nrValidade' => $faker->numberBetween(1, 5),
        'flAtivo' => $faker->boolean(),
        'flControlarEstoque' => $faker->boolean(),
        'stDescricao' => $faker->text(20),
        'idTipoProduto' => $faker->numberBetween(1, 5),
        'flPocket' => $faker->boolean(),
        'idSubCategoria' => 1,
        'nr10Mais' => 0,
        'dtUltimaVenda' => $faker->dateTimeBetween()->format('Y-m-d H:i:s'),
        'dtUltimaAlteracao' => $faker->dateTimeBetween()->format('Y-m-d H:i:s'),
        'flPromocao' => $faker->boolean(),
        'dtInicioPromocao' => $faker->date(),
        'dtFimPromocao' => $faker->date(),
        'vrUnitarioPromocao' => $faker->randomFloat(3, 1, 99),
        'flVendaCartao' => $faker->boolean(),
        'flVendaTicket' => $faker->boolean(),
        'flVendaSmart' => $faker->boolean(),
        'flRequererItemAdicional' => $faker->boolean(),
        'vrMargemLucro' => $faker->randomFloat(2, 1, 99),
        'flBalanca' => $faker->boolean(),
        'idMedidaCompra' => "1",
        'nrFatorConversao' => 0,
        'dtUltimaCompra' => $faker->dateTimeBetween()->format('Y-m-d H:i:s'),
        'dtAlteracao' => $faker->dateTimeBetween()->format('Y-m-d H:i:s'),
        'nrTipoProduto' => 0,
        'idProdutoVinculado' => null,
        'vrUnitario2' => $faker->randomFloat(3, 1, 99),
        'flCupomPreVenda' => $faker->boolean(),
        'idProdutoIntegracao' => null,
        'dtCriacao' => $faker->dateTimeBetween()->format('Y-m-d H:i:s'),
        'flDesconto' => $faker->boolean(),
        'nrNCM' => 19059090,
        'flPromocaoHora' => 0,
        'dtInicioPromocaoHora' => $faker->dateTimeBetween()->format('Y-m-d H:i:s'),
        'dtFimPromocaoHora' => $faker->dateTimeBetween()->format('Y-m-d H:i:s'),
        'vrUnitarioPromocaoHora' => $faker->randomFloat(5, 1, 99),
//        'stCest' => "1703100",
    ];
});
