<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCxHistoricoFechamentoTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('cx_HistoricoFechamento')) {
            Schema::create('cx_HistoricoFechamento', function (Blueprint $table) {
                $table->increments('id');
                $table->integer('idAbertura', false, true);
                $table->decimal('vrApurado', 18, 2);
                $table->decimal('vrFechamento', 18, 2);
                $table->decimal('vrDiferenca', 18, 2);
                $table->dateTime('dtData');
                $table->dateTime('dtAlteracao')->default(\Carbon\Carbon::now());
//                $table->primary('id');
            });

        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cx_HistoricoFechamento');
    }
}
