<?php

use Carbon\Carbon;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateEstKardexTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('est_Kardex')) {
            Schema::create('est_Kardex', function (Blueprint $table) {
                $table->dateTime('dtAlteracao')->default(Carbon::now());
                $table->integer('idKardex', false, true);
                $table->integer('idEstoque', false, true);
                $table->integer('idProduto', false,true);
                $table->decimal('nrSaldoAnterior', 11, 3);
                $table->decimal('nrSaldoAtual', 11, 3);
                $table->boolean('flEntrada');
                $table->decimal('nrQuantidade', 11, 3);
                $table->dateTime('dtData');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('est_Kardex');
    }
}
