<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class V53Migrations extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $this->changeClientesTable();
        $this->changeProductsTable();
        $this->changeMedidasTable();
        $this->changeSetoresTable();
        $this->changeCategoriasTable();
        $this->changeFormasPagamentoTable();
        $this->changeMicroTerminalTable();
        $this->changeAliquotasTable();
        $this->changeImpressorasTable();
        $this->changeOperadoresTable();
        $this->changeCodigosTable();
        $this->changeGerenciadorTable();
        $this->changeVendasTable();
        $this->changeVendasTempTable();
        $this->changeSangriasTable();
        $this->changeDespesasTable();
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }

    private function changeClientesTable()
    {
        if (Schema::hasTable('dlv_clientes')) {
            if (!Schema::hasColumn('dlv_clientes', 'sync')) {
                Schema::table('dlv_clientes', function (Blueprint $table) {
                    $table->boolean('sync')->default(false);
                });
            }
        }
    }

    private function changeProductsTable()
    {
        if (Schema::hasTable('prd_produtos')) {
            if (!Schema::hasColumn('prd_produtos', 'sync')) {
                Schema::table('prd_produtos', function (Blueprint $table) {
                    $table->boolean('sync')->default(false);
                });
            }
        }
    }

    private function changeMedidasTable()
    {
        if (Schema::hasTable('prd_medidas')) {
            if (!Schema::hasColumn('prd_medidas', 'sync')) {
                Schema::table('prd_medidas', function (Blueprint $table) {
                    $table->boolean('sync')->default(false);
                });
            }
        }
    }

    private function changeSetoresTable()
    {
        if (Schema::hasTable('prd_setores')) {
            if (!Schema::hasColumn('prd_setores', 'sync')) {
                Schema::table('prd_setores', function (Blueprint $table) {
                    $table->boolean('sync')->default(false);
                });
            }
        }
    }

    private function changeCategoriasTable()
    {
        if (Schema::hasTable('prd_Categorias')) {
            if (!Schema::hasColumn('prd_Categorias', 'sync')) {
                Schema::table('prd_Categorias', function (Blueprint $table) {
                    $table->boolean('sync')->default(false);
                });
            }
        }
    }

    private function changeFormasPagamentoTable()
    {
        if (Schema::hasTable('cx_FormasPagamento')) {
            if (!Schema::hasColumn('cx_FormasPagamento', 'sync')) {
                Schema::table('cx_FormasPagamento', function (Blueprint $table) {
                    $table->boolean('sync')->default(false);
                });
            }
        }
    }

    private function changeMicroTerminalTable()
    {
        if (Schema::hasTable('mt_Microterminais')) {
            if (!Schema::hasColumn('mt_Microterminais', 'sync')) {
                Schema::table('mt_Microterminais', function (Blueprint $table) {
                    $table->boolean('sync')->default(false);
                });
            }
        }
    }

    private function changeAliquotasTable()
    {
        if (Schema::hasTable('prd_Aliquotas')) {
            if (!Schema::hasColumn('prd_Aliquotas', 'sync')) {
                Schema::table('prd_Aliquotas', function (Blueprint $table) {
//                    $table->boolean('sync')->default(false);
                    $table->decimal('vrAliquota')->nullable()->change();
                });
            }

            if (Schema::hasColumn('prd_Aliquotas', 'vrAliquota')) {
                Schema::table('prd_Aliquotas', function (Blueprint $table) {
                    $table->decimal('vrAliquota')->nullable()->change();
                });
            }
        }
    }

    private function changeImpressorasTable()
    {
        if (Schema::hasTable('mt_Prints')) {
            if (!Schema::hasColumn('mt_Prints', 'sync')) {
                Schema::table('mt_Prints', function (Blueprint $table) {
                    $table->boolean('sync')->default(false);
                });
            }
        }
    }

    private function changeOperadoresTable()
    {
        if (Schema::hasTable('op_Operadores')) {
            if (!Schema::hasColumn('op_Operadores', 'sync')) {
                Schema::table('op_Operadores', function (Blueprint $table) {
                    $table->boolean('sync')->default(false);
                });
            }
        }
    }

    private function changeCodigosTable()
    {
        if (Schema::hasTable('prd_Codigos')) {
            if (!Schema::hasColumn('prd_Codigos', 'sync')) {
                Schema::table('prd_Codigos', function (Blueprint $table) {
                    $table->boolean('sync')->default(false);
                });
            }
        }
    }

    private function changeGerenciadorTable()
    {
        if (Schema::hasTable('cx_gerenciador')) {
            if (!Schema::hasColumn('cx_gerenciador', 'uuid')) {
                Schema::table('cx_gerenciador', function (Blueprint $table) {
                    $table->uuid('uuid')->nullable();
                });
            }
        }
    }

    private function changeVendasTable()
    {
        if (Schema::hasTable('cx_Vendas')) {
            if (!Schema::hasColumn('cx_Vendas', 'uuid')) {
                Schema::table('cx_Vendas', function (Blueprint $table) {
                    $table->uuid('uuid')->nullable();
                });
            }
        }
    }

    private function changeVendasTempTable()
    {
        if (Schema::hasTable('cx_Vendas_Temp')) {
            if (!Schema::hasColumn('cx_Vendas_Temp', 'uuid')) {
                Schema::table('cx_Vendas_Temp', function (Blueprint $table) {
                    $table->uuid('uuid')->nullable();
                });
            }
        }
    }

    private function changeSangriasTable()
    {
        if (Schema::hasTable('cx_Sangrias')) {
            if (!Schema::hasColumn('cx_Sangrias', 'uuid')) {
                Schema::table('cx_Sangrias', function (Blueprint $table) {
                    $table->uuid('uuid')->nullable();
                });
            }
        }
    }

    private function changeDespesasTable()
    {
        if (Schema::hasTable('cx_Despesas')) {
            if (!Schema::hasColumn('cx_Despesas', 'uuid')) {
                Schema::table('cx_Despesas', function (Blueprint $table) {
                    $table->uuid('uuid')->nullable();
                });
            }
        }
    }

}
