<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AlterSalesView extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        DB::statement($this->dropView());
        DB::statement($this->createView());
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        DB::statement($this->dropView());
    }

    private function createView()
    {
        return 'create view [dbo].[sales_list] as
            select v.idVenda, v.idAbertura, v.idCliente, c.stCliente, v.flAtivo, v.vrTotal as "vrTotalBruto", v.vrDesconto, v.vrAcrescimo, sum(v.vrTotal + v.vrAcrescimo - v.vrDesconto) as vrTotal, v.dtData, v.flNotaFiscal, g.idCaixa, g.idOperador, o.stApelido, v.chave_fiscal from cx_Vendas v
            inner join dlv_Clientes c on v.idCliente = c.idCliente
            inner join cx_Gerenciador g on g.idAbertura = v.idAbertura
            inner join op_Operadores o on o.idOperador = g.idOperador
            group by v.idVenda, v.idAbertura, v.idcliente, v.vrDesconto, v.vrAcrescimo, g.idOperador, v.dtData, v.flNotaFiscal, c.stCliente, v.flAtivo, g.idCaixa,o.stApelido, v.chave_fiscal, v.vrTotal
            union
            select v.idVenda, v.idAbertura, v.idCliente, c.stCliente, v.flAtivo, v.vrTotal as "vrTotalBruto", v.vrDesconto, v.vrAcrescimo, sum(v.vrTotal + v.vrAcrescimo - v.vrDesconto) as vrTotal, v.dtData, v.flNotaFiscal, g.idCaixa, g.idOperador, o.stApelido, v.chave_fiscal from cx_Vendas_Temp v
            inner join dlv_Clientes c on v.idCliente = c.idCliente
            inner join cx_Gerenciador g on g.idAbertura = v.idAbertura
            inner join op_Operadores o on o.idOperador = g.idOperador
            group by v.idVenda, v.idAbertura, v.idcliente, v.vrDesconto, v.vrAcrescimo, g.idOperador, v.dtData, v.flNotaFiscal, c.stCliente, v.flAtivo, g.idCaixa, o.stApelido, v.chave_fiscal, v.vrTotal';
    }

    private function dropView()
    {
        return "if exists(select 1 from sys.views where name='sales_list' and type='v')
                drop view sales_list;";
    }
}
