<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Carbon\Carbon;

class CreatePrdProdutosPerguntas extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('prd_ProdutosPerguntas')) {
            Schema::create('prd_ProdutosPerguntas', function (Blueprint $table) {
                $table->unsignedInteger('idProduto');
                $table->bigInteger('idPergunta');
                $table->dateTime('dtAlteracao')->default(DB::raw('GETDATE()'));
                $table->integer('nrOrdem')->default(1);

                $table->primary(['idProduto', 'idPergunta']);
                $table->foreign('idProduto')->references('idProduto')->on('prd_Produtos');
                $table->foreign('idPergunta')->references('idPergunta')->on('prd_Perguntas');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('prd_ProdutosPerguntas');
    }
}
