<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AlterPrdTabelasNutricionais extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(Schema::hasColumn('prd_TabelasNutricionais', 'nrProteinas')) {
            Schema::table('prd_TabelasNutricionais', function(Blueprint $table) {
                DB::statement("
                    IF EXISTS (SELECT 1 FROM sys.default_constraints WHERE name = 'DF_prd_TabelasNutricionais_nrProteinas' AND parent_object_id = OBJECT_ID('dbo.prd_TabelasNutricionais'))
                    BEGIN
                        ALTER TABLE [dbo].[prd_TabelasNutricionais] DROP CONSTRAINT [DF_prd_TabelasNutricionais_nrProteinas]
                    END
                ");
                $table->decimal('nrProteinas', 4, 1)->default(0)->change();
            });
        }
        if(Schema::hasColumn('prd_TabelasNutricionais', 'nrSodio')) {
            $columnType = DB::selectOne('SELECT COLUMN_NAME, DATA_TYPE FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = ? AND COLUMN_NAME = ?', ['prd_TabelasNutricionais', 'nrSodio']);
            Schema::table('prd_TabelasNutricionais', function(Blueprint $table) {
                DB::statement("
                    IF EXISTS (SELECT 1 FROM sys.default_constraints WHERE name = 'DF_prd_TabelasNutricionais_nrSodio' AND parent_object_id = OBJECT_ID('dbo.prd_TabelasNutricionais'))
                    BEGIN
                        ALTER TABLE [dbo].[prd_TabelasNutricionais] DROP CONSTRAINT [DF_prd_TabelasNutricionais_nrSodio]
                    END
                ");
                $table->decimal('nrSodio', 5, 1)->default(0)->change();
            });
        }
        if(Schema::hasColumn('prd_TabelasNutricionais', 'nrGordurasTotais')) {
            Schema::table('prd_TabelasNutricionais', function(Blueprint $table) {
                DB::statement("
                    IF EXISTS (SELECT 1 FROM sys.default_constraints WHERE name = 'DF_prd_TabelasNutricionais_nrGordurasTotais' AND parent_object_id = OBJECT_ID('dbo.prd_TabelasNutricionais'))
                    BEGIN
                        ALTER TABLE [dbo].[prd_TabelasNutricionais] DROP CONSTRAINT [DF_prd_TabelasNutricionais_nrGordurasTotais]
                    END
                ");
                $table->decimal('nrGordurasTotais', 4, 1)->default(0)->change();
            });
        }
        if(Schema::hasTable('prd_TabelasNutricionais')) {
            if(!Schema::hasColumn('prd_TabelasNutricionais', 'nrAcucaresTotais')) {
                Schema::table('prd_TabelasNutricionais', function(Blueprint $table) {
                    $table->decimal('nrAcucaresTotais', 4, 1)->default(0);
                });
            }
            if(!Schema::hasColumn('prd_TabelasNutricionais', 'nrAcucaresAdicionados')) {
                Schema::table('prd_TabelasNutricionais', function(Blueprint $table) {
                    $table->decimal('nrAcucaresAdicionados', 4, 1)->default(0);
                });
            }
            if(!Schema::hasColumn('prd_TabelasNutricionais', 'nrLactose')) {
                Schema::table('prd_TabelasNutricionais', function(Blueprint $table) {
                    $table->decimal('nrLactose', 5, 1)->default(0);
                });
            }
            if(!Schema::hasColumn('prd_TabelasNutricionais', 'nrGalactose')) {
                Schema::table('prd_TabelasNutricionais', function(Blueprint $table) {
                    $table->decimal('nrGalactose', 5, 1)->default(0);
                });
            }
            if(!Schema::hasColumn('prd_TabelasNutricionais', 'stTipo')) {
                Schema::table('prd_TabelasNutricionais', function(Blueprint $table) {
                    $table->string('stTipo')->default('rdc360')->nullable();
                });
            }
            if(!Schema::hasColumn('prd_TabelasNutricionais', 'nrQuantidadePorcoesEmbalagem')) {
                Schema::table('prd_TabelasNutricionais', function(Blueprint $table) {
                    $table->integer('nrQuantidadePorcoesEmbalagem')->default(1);
                });
            }
            if(!Schema::hasColumn('prd_TabelasNutricionais', 'flAltoAcucarAdicionado')) {
                Schema::table('prd_TabelasNutricionais', function(Blueprint $table) {
                    $table->boolean('flAltoAcucarAdicionado')->default(0);
                });
            }
            if(!Schema::hasColumn('prd_TabelasNutricionais', 'flAltoGorduraSaturada')) {
                Schema::table('prd_TabelasNutricionais', function(Blueprint $table) {
                    $table->boolean('flAltoGorduraSaturada')->default(0);
                });
            }
            if(!Schema::hasColumn('prd_TabelasNutricionais', 'flAltoSodio')) {
                Schema::table('prd_TabelasNutricionais', function(Blueprint $table) {
                    $table->boolean('flAltoSodio')->default(0);
                });
            }

        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
}
