<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMtItensExcluidos2Table extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('mt_ItensExcluidos2')) {

            DB::statement('CREATE TABLE [dbo].[mt_ItensExcluidos2](
                  [idItem] [int] NOT NULL,
                  [idComanda] [smallint] NOT NULL,
                  [idProduto] [int] NOT NULL,
                  [idOperadorExcluiu] [smallint] NOT NULL,
                  [stOperador] [nvarchar](20) NOT NULL,
                  [nrQuantidade] [decimal](9, 3) NOT NULL,
                  [dtData] [smalldatetime] NOT NULL,
                  [idMicroterminal] [nvarchar](15) NOT NULL,
                  [vrUnitario] [decimal](7, 2) NOT NULL,
                  [vrTotal] [decimal](7, 2) NOT NULL,
                  [dtAlteracao] [datetime] NOT NULL CONSTRAINT [DF_mt_ItensExcluidos2_dtAlteracao]  DEFAULT (getdate()),
                  CONSTRAINT [PK_mt_ItensExcluidos2] PRIMARY KEY CLUSTERED
                    (
                      [idItem] ASC,
                      [idComanda] ASC
                    )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
                ) ON [PRIMARY]');
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('mt_ItensExcluidos2');

    }
}
