<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateTbtCargaTributariaMediaTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('tbt_CargaTributariaMedia')) {

            DB::statement('CREATE TABLE [dbo].[tbt_CargaTributariaMedia](
                  [dtAlteracao] [datetime] NOT NULL CONSTRAINT [DF_tbt_CargaTributariaMedia_dtAlteracao]  DEFAULT (getdate()),
                  [stCodigo] [nvarchar](40) NOT NULL,
                  [nrEx] [int] NOT NULL CONSTRAINT [DF_tbt_CargaTributariaMedia_nrEx]  DEFAULT ((0)),
                  [nrTabela] [int] NOT NULL,
                  [vrAliqNac] [decimal](9, 2) NOT NULL,
                  [vrAliqImp] [decimal](9, 2) NOT NULL,
                  CONSTRAINT [PK_tbt_CargaTributariaMedia] PRIMARY KEY CLUSTERED
                    (
                      [stCodigo] ASC,
                      [nrEx] ASC
                    )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
                ) ON [PRIMARY]');
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tbt_CargaTributariaMedia');

    }
}
