<?php

namespace Database\Seeders;

use Carbon\Carbon;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class DlvClientesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        if (!DB::table('dlv_Clientes')->count()) {

            $data = [
                [
                    'idCliente' => 0,
                    'flPessoaJuridica' => 0,
                    'stCliente' => 'CONSUMIDOR',
                    'stNomeFantasia' => 'CONSUMIDOR',
                    'nrNumero' => 0,
                    'idCEP' => 0,
                    'flBloqueado' => 0,
                    'flAtivo' => 1,
                    'stVencimentosFatura' => '1@@@',
                    'dtCadastro' => Carbon::now(),
                    'stOperador' => 'ARCNET',
                    'vrSaldo' => 10.00,
                    'flContaAssinada' => 1,
                    'dtUltimaAlteracao' => Carbon::now(),
                    'stOperadorUltimaAlteracao' => 'ARCNET',
                    'stSexo' => 'I',
                    'flFuncionario' => 0,
                    'stOBSPrint' => 'SEM OBSERVACAO',
                    'nrTipoTerceiro' => 2,
                ]
            ];

            DB::table('dlv_Clientes')->insert($data);
        }
    }
}
