<?php

require_once __DIR__ . '/../../vendor/autoload.php';
function db_conn(){
//
    $dotenv = Dotenv\Dotenv::createImmutable(__DIR__.'/../../');
    $dotenv->load();

    global $conn;

    $host = env('DB_HOST');
    $user = env('DB_USERNAME');
    $pass = env('DB_PASSWORD');
    $dbase = env('DB_DATABASE');
    $port = env('DB_PORT');
    $engine = env('DB_CONNECTION');

    try{
        $conn = new PDO($engine.":server=".$host.";Database=".$dbase, $user, $pass, array(
            //PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_OBJ,
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::SQLSRV_ATTR_ENCODING => PDO::SQLSRV_ENCODING_UTF8,
            PDO::SQLSRV_ATTR_QUERY_TIMEOUT => 0
        ));
        return true;
    }catch(PDOException $ex){
       die($ex->getMessage());
    }
}

function mssql_connect($server, $user, $pass, $link = null){
    return db_conn();
}

function mssql_select_db($db = null, $cnn = null){
    return true;
}

function mssql_query($query, $link_identifier = null){
    global $conn;
    try{
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }catch(PDOException $ex){
        echo($query);
        die($ex->getMessage());
    }
}

function mssql_num_rows($stmt){
    try{
        $clone_stmt = $stmt;
        $new_stmt = mssql_query($clone_stmt->queryString);
        $new_stmt->execute();
        $i = 0;

        while($Clone = $new_stmt->fetchObject())
            $i++;

        return $i;
    }catch(PDOException $ex){
        die($ex->getMessage());
    }
}

function mssql_fetch_assoc($stmt){
    try{
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }catch(PDOException $ex){
        die($ex->getMessage());
    }
}

function mssql_fetch_array($stmt){
    try{
        return $stmt->fetch();
    }catch(PDOException $ex){
        die($ex->getMessage());
    }
}

function mssql_fetch_object($stmt){
    try{

        return $stmt->fetch(PDO::FETCH_OBJ);

    }catch(PDOException $ex){
        die($ex->getMessage());
    }
}

function mssql_fetch_row($stmt){
    try{
        return $stmt->fetch();
    }catch(PDOException $ex){
        die($ex->getMessage());
    }
}

function mssql_close($resource = null){
    $resource = null;
    return true;
}

function beginTransaction(){
    global $conn;

    $conn->beginTransaction();
}

function commit(){
    global $conn;
    $conn->commit();
}

function rollback(){
    global $conn;
    $conn->rollback();

}

?>
