<?php
header('Content-type: application/json');

chdir(dirname(realpath(__FILE__)));
require_once "../../functions.php";
db_conn();
session_start();


if (isset($_POST['action'])) {
	switch ($_POST['action']) {
		case 'cadastraCEP':
		cadastraCEP($_POST['stCEPCadastro'], $_POST['stEnderecoCadastro'], $_POST['stBairroCadastro'], strtoupper($_POST['stCidadeCadastro']), strtoupper($_POST['stEstadoCadastro']));
		break;
		case 'getDataByCep':
		getDataByCep($_POST['stCEP']);
		break;
		case 'getDataByStreet':
		getDataByStreet($_POST['stCidadeEscolha'], $_POST['stRuaEscolha']);
		break;
		case 'getDataByCepId':
		getDataByCepId($_POST['idCep']);
		break;
		case 'insertCadastroClientes':
		insertCadastroClientes(strtoupper($_POST['stCliente']), $_POST['nrDddTelefone'], $_POST['nrTelefone'], $_POST['idTipoTelefone'], $_POST['nrRamal'],
			$_POST['nrDddTelefone2'], $_POST['nrTelefone2'], $_POST['idTipoTelefone2'], $_POST['nrRamal2'], $_POST['flPessoaJuridica'], $_POST['stCEP'],
			$_POST['nrNumero'], strtoupper($_POST['stComplemento']), $_POST['stSexo'], $_POST['stCPF_CNPJ'], $_POST['stEmail'], strtoupper(trim($_POST['stEmpresa'])),
			$_POST['flRedirect'], (float)$_POST['vrEntrega'], strtoupper(trim($_POST['stOBS'])), strtoupper(trim($_POST['stOBSDelivery'])));
		break;
		case 'editCadastroClientes':
		editCadastroClientes($_POST['idCliente'], $_POST['idClienteOld'], $_POST['nrTelefoneOld'], $_POST['nrDddTelefoneOld'], $_POST['nrTelefoneOld2'], $_POST['nrDddTelefoneOld2'],
			strtoupper($_POST['stCliente']), $_POST['nrDddTelefone'], $_POST['nrTelefone'], $_POST['idTipoTelefone'], $_POST['nrRamal'],
			$_POST['nrDddTelefone2'], $_POST['nrTelefone2'], $_POST['idTipoTelefone2'], $_POST['nrRamal2'], $_POST['flPessoaJuridica'], $_POST['stCEP'],
			$_POST['nrNumero'], strtoupper($_POST['stComplemento']), $_POST['stSexo'], $_POST['stCPF_CNPJ'], $_POST['stEmail'], strtoupper(trim($_POST['stEmpresa'])),
			$_POST['flRedirect'], (float)$_POST['vrEntrega'], strtoupper(trim($_POST['stOBS'])), strtoupper(trim($_POST['stOBSDelivery'])));
		break;
		case 'getCidadePadrao':
		getCidadePadrao();
		break;
        case 'deleteCliente':
            deleteCliente($_POST['idCliente']);
            break;
	}
}

function deleteCliente($idCliente) {
    if (isset($idCliente)) {
        try{
            mssql_query("UPDATE dlv_Clientes SET flAtivo = 0 WHERE idCliente = '$idCliente'");
            echo retornaJson(true, 'success');

        }catch(Exception $exception){
            return retornaJson(false, "erro desconhecido");
        }
    } else {
        return retornaJson(false, 'Invalid id');
    }
}

function cadastraCEP($stCEP, $stEndereco, $stBairro, $stCidade, $stEstado)
{
	$res = mssql_query("SELECT COUNT(*) FROM dlv_Ceps WHERE stCEP = '$stCEP'");
	$arr = mssql_fetch_array($res);

	if ($arr[0] > 0){
		die(retornaJson(false, "Este CEP já está cadastrado"));
	}

	$res = mssql_query("SELECT MAX(idCEP) FROM dlv_Ceps");
	$arr = mssql_fetch_array($res);
	$idCEP = $arr[0] + 1;

	$date = date('Y/m/d h:i:s a', time());
	mssql_query("INSERT INTO dlv_Ceps (idCEP, stCEP, stEndereco, stBairro, stCidade, stEstado, dtAlteracao) VALUES ('$idCEP', '$stCEP', '$stEndereco', '$stBairro', '$stCidade', '$stEstado', '$date')");
	die(retornaJson(true, "CEP cadastrado com sucesso"));
}

function getDataByStreet($stCidade, $stRua)
{
	$res = mssql_query("SELECT idCep, stEndereco FROM dlv_Ceps WHERE stEndereco like '%".$stRua."%' AND stCidade = '$stCidade'");
	$cnt = mssql_num_rows($res);
	$result = array();
	if($cnt > 0){
		while ($arr = mssql_fetch_array($res)){
			$result[] = $arr['idCep'];
			$result[] = $arr['stEndereco'];
		}
	}

	echo json_encode($result);
}

function getDataByCep($stCep)
{
	$res = mssql_query("SELECT TOP(1) * FROM dlv_CEPs WHERE stCEP = '".$stCep."'");
	$arr = mssql_fetch_assoc($res);
	$arr['stEndereco'] = utf8_encode($arr['stEndereco']);
	$arr['stBairro'] = utf8_encode($arr['stBairro']);
	$arr['stCidade'] = utf8_encode($arr['stCidade']);
	echo json_encode($arr);
}

function getDataByCepId($idCep)
{
	$res = mssql_query("SELECT * FROM dlv_CEPs WHERE idCep = '".$idCep."'");
	$arr = mssql_fetch_assoc($res);
	$arr['stEndereco'] = utf8_encode($arr['stEndereco']);
	$arr['stBairro'] = utf8_encode($arr['stBairro']);
	$arr['stCidade'] = utf8_encode($arr['stCidade']);
	echo json_encode($arr);
}

function insertCadastroClientes($stCliente, $nrDddTelefone, $nrTelefone, $idTipoTelefone, $nrRamal, $nrDddTelefone2, $nrTelefone2, $idTipoTelefone2, $nrRamal2, $flPessoaJuridica, $stCEP, $nrNumero, $stComplemento, $stSexo, $stCPF_CNPJ, $stEmail, $stEmpresa, $flRedirect, $vrEntrega, $stOBS, $stOBSDelivery)
{
    beginTransaction();

	$UID = $_COOKIE['dlvOperador'];
	$LOG = $_COOKIE['dlvLogado'];

    $res = mssql_query("SELECT * FROM op_Operadores WHERE idOperador = '$UID'");
    $arr = mssql_fetch_array($res);
    $APELIDO = $arr['stApelido'];
	$flBloqueado = 0;
	$flAtivo = 1;
	$dtCadastro = date("Y-m-d H:i:s");
    $stOperador = $APELIDO;
    $stOperadorUltimaAlteracao = $APELIDO;
	$vrSaldo = 0;
	$vrLimite = 0;
	$flContaAssinada = 0;
	$dtUltimaAlteracao = date("Y-m-d H:i:s");
	$dtUltimaCompra = date("Y-m-d H:i:s");

	if (strlen($stCPF_CNPJ) == 0) {
		$stCPF_CNPJ = '';
	}
	else if(strlen($stCPF_CNPJ) < 8 || strlen($stCPF_CNPJ) > 14){
		die(retornaJson(false, "Erro! CPF/CNPJ inválido!"));
	}

	if(!$nrTelefone){
		if(!$nrTelefone2){
			die(retornaJson(false, "Erro! Deve ser cadastrado pelo menos um telefone!"));
		}else{
			if(!$nrDddTelefone2 || strlen($nrDddTelefone2) == 1 || strlen($nrDddTelefone2) > 2){
				die(retornaJson(false, "Erro! DDD inválido"));
			}
		}
	}else{
		if(!$nrDddTelefone || strlen($nrDddTelefone) == 1 || strlen($nrDddTelefone) > 2){
			die(retornaJson(false, "Erro! DDD inválido"));
		}
	}

	if (!$stCliente || !$nrTelefone || !$idTipoTelefone || !$stCEP || !$nrNumero) {
		die(retornaJson(false, "Erro! Algumas informações estão faltando para o cadastro"));
	} else {
		if ($nrTelefone == $nrTelefone2) {
			die(retornaJson(false, "Erro! Os números de telefone estão iguais!"));
		}
		$cepSql = mssql_query("SELECT idCep from dlv_CEPs where stCEP = '$stCEP'");
		$cepRes = mssql_fetch_array($cepSql);
		$idCEP = $cepRes[0];

		$res = mssql_query("SELECT MAX(idCliente) as idCliente FROM dlv_Clientes");
		$arr = mssql_fetch_array($res);
		$idCliente = $arr['idCliente'] + 1;

		$trans = true;

//		beginTransaction();

		$sql1 = "INSERT INTO dlv_Clientes (idCliente, flPessoaJuridica, stCliente, nrNumero, stComplemento, idCEP, stSexo, flBloqueado, flAtivo, dtCadastro, stOperador, vrSaldo, vrLimite, flContaAssinada, dtUltimaAlteracao, dtUltimaCompra,
		stOperadorUltimaAlteracao, vrEntrega, stOBS, stOBSDelivery,stEmail,stCPF_CNPJ,stEmpresa, stVencimentosFatura, nrTipoTerceiro, dtAlteracao, vrSaldoPagamento, vrDescontoVenda, idMotivoBloqueio, flFuncionario)
		VALUES ('$idCliente', '$flPessoaJuridica', '$stCliente', '$nrNumero', '$stComplemento', '$idCEP', '$stSexo', '$flBloqueado', '$flAtivo', GETDATE(), '$stOperador', '$vrSaldo',
		'$vrLimite', '$flContaAssinada', GETDATE(),GETDATE(), '$stOperadorUltimaAlteracao', '$vrEntrega', '$stOBS', '$stOBSDelivery', '$stEmail', '$stCPF_CNPJ', '$stEmpresa',
		'7@@@', '2', GETDATE(), '0.00', '0.00', '0', '0')";

		mssql_query($sql1) ;
		mssql_query("INSERT INTO dlv_Telefones (idCliente, nrTelefone, nrRamal, idTipoTelefone, flAtivo, dtAlteracao) VALUES
			('$idCliente', '$nrDddTelefone"."$nrTelefone', '$nrRamal', '$idTipoTelefone', '$flAtivo', GETDATE())") ;
		if (strlen(trim($_POST['nrTelefone2'])) > 0) {
			mssql_query("INSERT INTO dlv_Telefones (idCliente, nrTelefone, nrRamal, idTipoTelefone, flAtivo, dtAlteracao)
				VALUES ('$idCliente', '$nrDddTelefone2"."$nrTelefone2', '$nrRamal2', '$idTipoTelefone2', '$flAtivo', GETDATE())") ;
		}
		if ($trans) {
			commit();

			if ($flRedirect) {
				die(retornaJson(true, "Cadastrado com sucesso!<br><br>Redirecionando...", "index.php?sec=novoPedido&id=" . $idCliente."", 1000));
			} else {
				die(retornaJson(true, "Cadastrado com sucesso!<br><br>Redirecionando...", "index.php?sec=index.php", 1000));
			}
		} else {
			rollback();
			die(retornaJson(false, "Error! Cliente não cadastrado"));
		}
	}
}
function editCadastroClientes($idCliente, $idClienteOld, $nrTelefoneOld, $nrDddTelefoneOld, $nrTelefoneOld2, $nrDddTelefoneOld2, $stCliente, $nrDddTelefone, $nrTelefone, $idTipoTelefone, $nrRamal, $nrDddTelefone2, $nrTelefone2, $idTipoTelefone2, $nrRamal2, $flPessoaJuridica, $stCEP, $nrNumero, $stComplemento, $stSexo, $stCPF_CNPJ, $stEmail, $stEmpresa, $flRedirect, $vrEntrega, $stOBS, $stOBSDelivery){

    beginTransaction();

    $UID = $_COOKIE['dlvOperador'];
	$LOG = $_COOKIE['dlvLogado'];


    $res = mssql_query("SELECT * FROM op_Operadores WHERE idOperador = '$UID'");
    $arr = mssql_fetch_array($res);
    $APELIDO = $arr['stApelido'];

	$flBloqueado = 0;
	$flAtivo = 1;
	$stOperador = $APELIDO;
    $stOperadorUltimaAlteracao = $APELIDO;

	if (strlen($stCPF_CNPJ) == 0) {
		$stCPF_CNPJ = '';
	}
	else if(strlen($stCPF_CNPJ) < 8 || strlen($stCPF_CNPJ) > 14){
		die(retornaJson(false, "Erro! CPF/CNPJ inválido!"));
	}

	if(!$nrTelefone){
		if(!$nrTelefone2){
			die(retornaJson(false, "Erro! Deve ser cadastrado pelo menos um telefone!"));
		}else{
			if(!$nrDddTelefone2 || strlen($nrDddTelefone2) == 1 || strlen($nrDddTelefone2) > 2){
				die(retornaJson(false, "Erro! DDD inválido"));
			}
		}
	}else{
		if(!$nrDddTelefone || strlen($nrDddTelefone) == 1 || strlen($nrDddTelefone) > 2){
			die(retornaJson(false, "Erro! DDD inválido"));
		}
	}

	$cepSql = mssql_query("SELECT idCep from dlv_CEPs where stCEP = '".$stCEP."'");
	$cepRes = mssql_fetch_array($cepSql);
	$idCEP = $cepRes[0];

	if (!$idCliente || !$stCliente || !$nrTelefone || !$idTipoTelefone  || !$idCEP || !$nrNumero )
	{
		die(retornaJson(false, "Erro! Existem informações faltando para a edição"));
	}
	else
	{
		$res = mssql_query("SELECT COUNT(*) FROM dlv_Clientes WHERE idCliente = '$idCliente'");
		$arr = mssql_fetch_array($res);

		if ($arr[0] > 0 && $idCliente != $idClienteOld)
		{
			die(retornaJson(false, "Erro! Número de Cliente Inválido!"));
		}
		if ($nrTelefone == $nrTelefone2)
		{
			die(retornaJson(false, "Erro! Os números de telefone estão iguais!"));
		}

		$trans = true;

//		beginTransaction();

		mssql_query("UPDATE dlv_Clientes SET idCliente='$idCliente', flPessoaJuridica='$flPessoaJuridica', "
			. "stCliente='$stCliente', nrNumero='$nrNumero', stComplemento='$stComplemento', idCEP='$idCEP', "
			. "stSexo='$stSexo', flBloqueado='$flBloqueado', flAtivo='$flAtivo',  "
			. "stOperador='$stOperador', "
			. "dtUltimaAlteracao= getDate(), stOperadorUltimaAlteracao='$stOperadorUltimaAlteracao', vrEntrega='$vrEntrega', stOBS='$stOBS', stOBSDelivery='$stOBSDelivery', stEmail='$stEmail', stCPF_CNPJ='$stCPF_CNPJ', stEmpresa ='$stEmpresa' WHERE idCliente = '$idClienteOld'") ;

		mssql_query("DELETE FROM dlv_Telefones WHERE idCliente = '$idCliente' AND nrTelefone = '$nrTelefoneOld'") ;
		$nrTelefone = $nrDddTelefone .''. $nrTelefone;
		$nrTelefone2 = $nrDddTelefone2 .''. $nrTelefone2;
		mssql_query("INSERT INTO dlv_Telefones (idCliente, nrTelefone, nrRamal, idTipoTelefone, flAtivo, dtAlteracao) VALUES ('$idCliente', '$nrTelefone', '$nrRamal', '$idTipoTelefone', '$flAtivo', GETDATE())") ;

		if (strlen(trim($_POST['nrTelefone2'])) > 0)
		{
			mssql_query("DELETE FROM dlv_Telefones WHERE idCliente = '$idCliente' AND nrTelefone = '$nrTelefoneOld2'") ;
			mssql_query("INSERT INTO dlv_Telefones (idCliente, nrTelefone, nrRamal, idTipoTelefone, flAtivo, dtAlteracao) VALUES ('$idCliente', '$nrTelefone2', '$nrRamal2', '$idTipoTelefone2', '$flAtivo', GETDATE())") ;
		}

		if ($trans)
		{
			commit();
			if ($flRedirect)
				redirect("index.php?sec=novoPedido&id=".$idCliente);
			else
				echo retornaJson(true, "Editado com sucesso!<br><br>Redirecionando...", "index.php?sec=buscaClientes", 1000);
		}
		else
		{
			rollback();
			die(retornaJson(false, "Error! Cliente não editado"));
		}
	}
}

function getCidadePadrao()
{
	$res = mssql_query("SELECT stCidade FROM dlv_Config WHERE idDelivery = '" . $_SERVER['REMOTE_ADDR'] . "'");
	$arr = mssql_fetch_assoc($res);
	$arr['stCidade'] = utf8_encode($arr['stCidade']);
	echo json_encode($arr);
}
?>
