<div class="container">
    <br/>
    <div class="col-md-12">
        <h2>Faturas Pendentes</h2>
        <hr>
    </div>
    <div id="filter-panel">
        <div class="panel panel-default">
            <div class="panel-body">
                <div class="form-group col-md-6 col-md-offset-2">
                    <div class="input-group">
                        <div class="input-group-addon">De:</div>
                        <input type="text" name="datepicker" id="de" class="form-control data"/>
                        <div class="input-group-addon">Até:</div>
                        <input type="text" name="datepicker" id="ate" class="form-control data"/>
                    </div>
                </div>
                <div class="form-group col-md-2">
                    <a class="btn btn-primary" onclick="getData()">
                        <span class="glyphicon glyphicon-search"></span> Buscar
                    </a>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="panel" id="conteudo-empty" hidden>
                <div class="alert alert-warning col-md-10 col-md-offset-1" role="alert">
                    <h4 class="text-center">Nenhum resultado foi encontrado para o periodo selecionado!</h4>
                </div>
            </div>
            <div class="panel">
                <div class="panel panel-body" id="conteudo" hidden>


                </div>
            </div>
        </div>
        <div class="modal-loader"></div>
    </div>
</div>

<script>
    $(document).ready(function () {
        $("#conteudo-empty").hide();
        $("[name='datepicker']").change(function () {
        });
        setDateFields();
    });

    function getData() {
        $('#relTable').empty();
        $("#conteudo").hide();
        data = {
            action: 'faturasPendentes',
            dataInicial: $('#de').val(),
            dataFinal: $('#ate').val(),
        };

        $.post('custom/customController.php', data, function (response) {

            console.log(response.itens);

            for (var x = 0; x < response.itens.length; x++) {
                var linha = '';

                console.log(response.itens[x]);
                var it = response.itens[x];
                linha += '<div class="col-md-12">';
                linha += '<div class="bs-example">';
                linha += '<caption><h4>' + it['idCliente'] + ' - ' + it['stCliente'] + '</h4></caption>';
                linha += '<table class="table">';
                linha += '<thead> <tr> <th class="col-md-1">Data</th> <th class="col-md-8">Cliente</th><th class="col-md-3">Valor do Titulo</th></thead>';
                linha += '<tbody>';

                var totalCliente = 0;
                for (var y = 0; y < it.faturas.length; y++) {
                    var fat = it.faturas[y];

                    linha += '<td>' + fat['dtLancamento'] + '</td>';
                    linha += '<td>' + it['idCliente'] + ' - ' + it['stCliente'] + '</td>';
                    linha += '<td> R$ ' + fat['vrDocumento'] + '</td>';

                    linha += '</tr>';
                    totalCliente += parseFloat(fat['vrDocumento']);
                }
                linha += '</tbody>';
                linha += '<tfoot>';
                linha += '<tr>';
                linha += '<td></td>';
                linha += '<td></td>';
                linha += '<td><h4> R$ ' + parseFloat(totalCliente).toFixed(2) + '</h4></td>';
                linha += '<tr>';
                linha += '</tfoot>';
                linha += '</table>';

                linha += '</div>';
                linha += '</div><br />';
                $(linha).appendTo($('#conteudo'));

            }
            $("body").removeClass("loading");
            $("#conteudo").show();
        });
    }

</script>