var gulp = require('gulp');
var concat = require('gulp-concat');

gulp.task('default', ['styles', 'scripts', 'copyfonts', 'images'], function () {
});

gulp.task('styles', function () {
    gulp.src([
        './node_modules/bootstrap/dist/css/bootstrap.css',
        './node_modules/bootstrap/dist/css/bootstrap-theme.css',
        './node_modules/bootstrap-datepicker/dist/css/bootstrap-datepicker3.css',
        './node_modules/datatables/media/css/jquery.dataTables.css',
        './node_modules/datatables.net-buttons-dt/css/buttons.dataTables.css',
        './node_modules/select2/dist/css/select2.css',
        './node_modules/select2-bootstrap-theme/dist/select2-bootstrap.css',
        './node_modules/sweetalert2/dist/sweetalert2.css',
        './node_modules/select2/dist/css/select2.css',
        './node_modules/select2-bootstrap-theme/dist/select2-bootstrap.css',
        './node_modules/font-awesome/css/font-awesome.css',
        './node_modules/glyphicons-halflings/css/glyphicons-halflings.css',
        './node_modules/toastr/toastr.scss'
    ])
        .pipe(concat('app.css'))
        .pipe(gulp.dest('./assets/css/'));
});

gulp.task('scripts', function () {
    gulp.src([
        './node_modules/jquery/dist/jquery.js',
        './node_modules/bootstrap/dist/js/bootstrap.js',
        './node_modules/jquery-mask-plugin/dist/jquery.mask.js',
        './node_modules/jquery-maskmoney/dist/jquery.maskMoney.js',
        './node_modules/bootstrap-datepicker/dist/js/bootstrap-datepicker.js',
        './node_modules/bootstrap-datepicker/dist/locales/bootstrap-datepicker.pt-BR.min.js',
        './node_modules/select2/dist/js/select2.js',
        './node_modules/select2/dist/js/i18n/pt-BR.js',
        './node_modules/sweetalert2/dist/sweetalert2.js',
        './node_modules/datatables/media/js/jquery.dataTables.js',
        './node_modules/datatables.net-buttons/js/dataTables.buttons.js',
        './node_modules/datatables.net-buttons/js/buttons.colVis.js',
        './node_modules/datatables.net-buttons/js/buttons.flash.js',
        './node_modules/datatables.net-buttons/js/buttons.print.js',
        './node_modules/datatables.net-buttons/js/buttons.html5.js',
        './node_modules/toastr/toastr.js',
        './node_modules/moment/moment.js',
        './node_modules/moment/locale/pt-br.js',
    ])
        .pipe(concat('app.js'))
        .pipe(gulp.dest('./assets/js/'));
});

gulp.task('copyfonts', function () {
    gulp.src([
        './node_modules/bootstrap/fonts/**/*',
        './node_modules/font-awesome/fonts/**/*'

    ])
        .pipe(gulp.dest('./assets/fonts/'));
});

gulp.task('images', function () {
    gulp.src([
        './node_modules/datatables/media/images/*.*'
    ])
        .pipe(gulp.dest('./assets/images/'));
})