document.addEventListener("DOMContentLoaded", function() {
	getProdutos();

});

function getProdutos() {
	$.post('produtos/resources/php/geral_functions.php', {action: 'getNCMProdutos'}, function (response) {
		var linha = '';
		if (!response) {
			linha = '<tr><td colspan="8" align="center">NENHUM NCM ERRADO</td></tr>';
			$(linha).appendTo($("#bodyListagem"));
			return false;
		}
		for (var i = 0; i < response.length; i++) {
			linha += '<tr>';
			linha += '<td>'+response[i]['idCodigo']+'</td>';
			linha += '<td>'+response[i]['stProduto']+'</td>';
			linha += '<td><input id="produto'+response[i]['idProduto']+'" class="form-control input-sm" type="text" maxlength="8" value="'+response[i]['nrNCM']+'"></td>';
			linha += '</tr>';
		}
		$(linha).appendTo($("#bodyListagem"));
	});
}

function salvar(){
	toastr.options = {"positionClass": "toast-bottom-right"};
	var action = 'salvarNovosNCM';
	var produtos = [];
	var idProduto = '';
	var ncm = '';
	$('input[id^="produto"]').each(function(){
		idProduto = $(this).attr('id');
		idProduto = idProduto.replace('produto', '');
		ncm = $(this).val();
		produtos.push({idProduto, ncm});
	});
	produtos = JSON.stringify(produtos);
	var data = {
		action: action, 
		produtos: produtos
	};

	$.post('produtos/resources/php/geral_functions.php', data, function (response) {
		if(response.status){
			toastr.success(response.msg);
			setTimeout(function(){location.reload();},1000);
		}else{
			toastr.error(response.msg);
		} 
	});
}

