<?php
header('Content-type: application/json');
ini_set("memory_limit", "512M");
chdir(dirname(realpath(__FILE__)));
require_once "../../../functions.php";
require "../../../classes/class.phpmailer.php";

db_conn();

if (isset($_POST['action'])) {
    switch ($_POST['action']) {
        case 'initExtratoCliente':
            initExtratoCliente($_POST['de'], $_POST['ate']);
            break;
        case 'gerarExtrato':
            gerarExtrato($_POST['idCliente'], $_POST['de'], $_POST['ate'], $_POST['optradio']);
            break;
        case 'sendMailExtrato':
            sendMailExtrato($_POST['idCliente'], $_POST['de'], $_POST['ate']);
            break;
        case 'getDadosOperador':
            getDadosOperador();
            break;
        case 'getDadosCliente':
            getDadosCliente($_POST['idCliente']);
            break;
        case 'getProdutosExtrato':
            getProdutosExtrato($_POST['idCliente'], $_POST['de'], $_POST['ate']);
            break;
        case 'getSaldoAnterior':
            getSaldoAnterior($_POST['idCliente'], $_POST['date']);
            break;
    }
}

function initExtratoCliente($de, $ate)
{
    $de = explode('/', $de);
    $dtDe = $de[2] . '-' . $de[1] . '-' . $de[0] . ' 00:00:00';
    $ate = explode('/', $ate);
    $dtAte = $ate[2] . '-' . $ate[1] . '-' . $ate[0] . ' 23:59:59';

    $qry = "SELECT DISTINCT idCliente, stCliente, stEmail FROM dlv_Clientes
            WHERE flContaAssinada = '1' AND flAtivo = '1' AND idCliente > '0'
            and idCliente in(
            SELECT idCliente FROM cli_Extrato WHERE dtData BETWEEN '" . $dtDe . "' AND '" . $dtAte . "'
            )
            ORDER BY stCliente";

    $res = mssql_query($qry);
    while ($arr = mssql_fetch_assoc($res)) {
        $arr['stCliente'] = utf8_encode($arr['stCliente']);
        if (!strpos($arr['stEmail'], '@')) {
            $arr['flNaoEnvia'] = 1;
        }

        $sql = "SELECT COUNT(idExtrato) FROM cli_Extrato WHERE idCliente = " . $arr['idCliente'] . " AND dtData BETWEEN '" . $dtDe . "' AND '" . $dtAte . "'";
        // var_dump($sql);

        $resExtrato = mssql_query($sql);
        $num = mssql_fetch_array($resExtrato);
        if ($num[0] == 0) {
            $arr['flNTemMovimento'] = 1;
        }

        $rows[] = $arr;
    }
    echo json_encode($rows);
}

function getDadosOperador()
{
    $res = mssql_query("SELECT idOperador, stApelido FROM op_Operadores WHERE idOperador = " . $_COOKIE['idOperador']);
    $arr = mssql_fetch_array($res);
    $arr['stApelido'] = utf8_encode($arr['stApelido']);
    echo json_encode($arr);
}

function getDadosCliente($idCliente)
{
    $sql1 = "SELECT stCliente, idCliente, vrSaldo, nrNumero, idCEP FROM dlv_Clientes WHERE idCliente = '$idCliente'";
    $res = mssql_query($sql1);
    $arr = mssql_fetch_array($res);

    $arr['stCliente'] = utf8_encode($arr['stCliente']);
    $arr['vrSaldo'] = number_format($arr['vrSaldo'], 2, ',', '.');

    $sql3 = "SELECT stEndereco, stBairro FROM dlv_Ceps WHERE idCEP = " . $arr['idCEP'];
    $res = mssql_query($sql3);
    $end = mssql_fetch_array($res);

    $end['stEndereco'] = utf8_encode($end['stEndereco']);
    $end['stBairro'] = utf8_encode($end['stBairro']);

    $arr['stEndereco'] = $end['stEndereco'] . ", " . $arr['nrNumero'] . " - " . $end['stBairro'];

    echo json_encode($arr);
}

function getProdutosExtrato($idCliente, $de, $ate)
{
    $sqlMaster = "SELECT * FROM Master";
    $res = mssql_query($sqlMaster);
    $ar = mssql_fetch_array($res);
    $flUsarPrecoAtual = $ar['flUsarPrecoAtual'];

    $de = explode('/', $de);
    $dtDe = $de[2] . '-' . $de[1] . '-' . $de[0] . ' 00:00:00';
    $ate = explode('/', $ate);
    $dtAte = $ate[2] . '-' . $ate[1] . '-' . $ate[0] . ' 23:59:59';

    $sql = "SELECT P.stProdutoAbreviado, M.flFracionado, M.stMedida, I.vrUnitario, sum(I.vrTotal) as vrTotal, sum(I.nrQuantidade) as nrQuantidade, P.vrUnitario AS vrUnitarioAtual
	FROM cli_ItemExtrato I
	INNER JOIN cli_Extrato E on I.idExtrato = E.idExtrato AND I.idAbertura = E.idAbertura
	INNER JOIN dlv_Clientes C ON C.idCliente = E.idCliente
	INNER JOIN prd_Produtos P on P.idProduto = I.idProduto
	INNER JOIN prd_Medidas M on M.idMedida = P.idMedida
	WHERE C.idCliente = '$idCliente' AND convert(char(20),I.dtData,120) BETWEEN '$dtDe' AND '$dtAte' AND I.flAtivo = '1' AND E.flAtivo = '1'
	GROUP BY P.stProdutoAbreviado, M.flFracionado, M.stMedida, P.vrUnitario, I.vrUnitario
	ORDER BY P.stProdutoAbreviado";

    $res = mssql_query($sql);
    while ($arr = mssql_fetch_assoc($res)) {
//		if ($arr['vrDesconto'] > 0) {
//			$arr['vrDesconto'] = $arr['vrDesconto'] * -1;
//		}
        $arr['stProdutoAbreviado'] = utf8_encode($arr['stProdutoAbreviado']);
        $arr['stMedida'] = utf8_encode($arr['stMedida']);

        if ($arr['flFracionado']) {
            $arr['nrQuantidade'] = $arr['nrQuantidade'] / 1000;
            $arr['nrQuantidade'] = number_format($arr['nrQuantidade'], 3, ',', '.');
        }

//        if ($flUsarPrecoAtual) {
//            $arr['vrTotal'] = $arr['vrUnitarioAtual'] * $arr['nrQuantidade'];
//        }

        $rows[] = $arr;
    }

    echo json_encode($rows);
}

function gerarExtrato($idCliente, $de, $ate, $optradio)
{
    $sqlMaster = "SELECT * FROM Master";
    $res = mssql_query($sqlMaster);
    $ar = mssql_fetch_array($res);

    $de = explode('/', $de);
    $dtDe = $de[2] . '-' . $de[1] . '-' . $de[0] . ' 00:00:00';
    $ate = explode('/', $ate);
    $dtAte = $ate[2] . '-' . $ate[1] . '-' . $ate[0] . ' 23:59:59';

    $sql = "SELECT 'VENDA' as Tipo, E.dtData, E.idCliente, E.idExtrato, E.idAbertura, E.vrTotal, E.vrQuitado, E.vrAcrescimo, ((E.vrTotal + E.vrAcrescimo) - E.vrQuitado) as vrSoma,E.vrDesconto, E.vrSaldoAnterior, C.stCliente, C.vrSaldo, V.chave_fiscal
	FROM cli_Extrato E
    INNER JOIN dlv_Clientes C ON C.idCliente = E.idCliente
    INNER JOIN cx_vendas V on V.idAbertura = E.idAbertura and V.idVenda = E.idVenda
	WHERE E.idCliente = '$idCliente' AND convert(char(20),E.dtData,120) BETWEEN '$dtDe' AND '$dtAte' AND E.flAtivo = '1' --and E.idFatura = '0'
	UNION
	SELECT
	'DEPOSITO' as Tipo, P.dtData, P.idCliente, '0' as idExtrato, P.idAbertura, P.vrPagamento as vrTotal, '0' as vrQuitado,'0' as vrAcrescimo, P.vrPagamento as vrSoma,0 as vrDesconto,P.vrSaldoAnterior, C.stCliente, C.vrSaldo, null as chave_fiscal
	FROM cli_Pagamento P
	INNER JOIN dlv_Clientes C ON C.idCliente = P.idCliente
	WHERE P.idCliente = '$idCliente' AND convert(char(20),P.dtData,120) between '$dtDe' AND '$dtAte' and P.flAtivo =  '1'
	ORDER by dtData";

//	die($sql);

    $res = mssql_query($sql);
    while ($arr = mssql_fetch_assoc($res)) {
        $arr['stCliente'] = utf8_encode($arr['stCliente']);
        if ($arr['vrDesconto'] > 0) {
            $arr['vrDesconto'] = -$arr['vrDesconto'];
        }

        $arr['dtData'] = date("d/m/Y H:i", strtotime($arr['dtData']));
        if ($arr['Tipo'] == 'VENDA') {
            $qryPrd = "SELECT P.stProdutoAbreviado, M.flFracionado, M.stMedida, I.dtData, C.idCodigo,
			sum(I.vrTotal) as vrTotal, sum(I.nrQuantidade) as nrQuantidade, P.vrUnitario AS vrUnitarioAtual
			FROM cli_ItemExtrato I
			INNER JOIN prd_Produtos P on P.idProduto = I.idProduto
			INNER JOIN prd_Medidas M on M.idMedida = P.idMedida
			INNER JOIN (SELECT MIN(idCodigo) AS idCodigo, idProduto FROM prd_Codigos GROUP BY idProduto) C on C.idProduto = P.idProduto
			WHERE idabertura = '" . $arr['idAbertura'] . "' AND idExtrato = '" . $arr['idExtrato'] . "' AND I.flAtivo = 1
			GROUP BY P.stProdutoAbreviado, M.flFracionado, M.stMedida, I.dtData, C.idCodigo, P.vrUnitario";
            $resPrd = mssql_query($qryPrd);
            while ($arrPrd = mssql_fetch_assoc($resPrd)) {
                $arrPrd['stProdutoAbreviado'] = utf8_encode($arrPrd['stProdutoAbreviado']);
                $arrPrd['stMedida'] = utf8_encode($arrPrd['stMedida']);

                if ($arrPrd['flFracionado']) {
                    $arrPrd['nrQuantidade'] = $arrPrd['nrQuantidade'] / 1000;
                    $arrPrd['nrQuantidade'] = number_format($arrPrd['nrQuantidade'], 3, ',', '.');
                }

                $arr['vendas'][] = $arrPrd;
            }
        }
        $rows[] = $arr;
    }
    echo json_encode($rows);
}

function getSaldoAnterior($idCliente, $de)
{
    $de = explode('/', $de);
    $dtDe = $de[2] . '-' . $de[1] . '-' . $de[0];

    $qrySaldoAnterior = "
select (
	(select COALESCE(SUM(vrPagamento),0) from cli_Pagamento where dtData <  '$dtDe' and flAtivo = 1 and idCliente = '$idCliente') -
	(select COALESCE(sum(vrTotal - vrQuitado),0) from cli_Extrato where dtData <  '$dtDe' and flAtivo = 1 and idCliente = '$idCliente')
) as totalAnterior";

    $resSaldoAnterior = mssql_query($qrySaldoAnterior);
    $arrSaldoAnterior = mssql_fetch_object($resSaldoAnterior);

    echo json_encode($arrSaldoAnterior->totalAnterior);
}

function sendMailExtrato($idCliente, $de, $ate)
{
    $mail = new PHPMailer(true);

// Define os dados do servidor e tipo de conexão
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
    $mail->IsSMTP(); // Define que a mensagem será SMTP
    $qry = mssql_query('SELECT * FROM EMAIL');
    $arr = mssql_fetch_assoc($qry);
    if (mssql_num_rows($qry) == 0) {
        echo retornaJson(false, 'Nao tem email configurado');
        die;
    }

    $arr['senha'] = base64_decode($arr['senha']);

    $qry = mssql_query('SELECT * FROM dlv_Clientes WHERE idCliente = ' . $idCliente);
    $cli = mssql_fetch_assoc($qry);
    if (!strpos($cli['stEmail'], '@')) {
        echo retornaJson(false, 'O cliente não tem um email valido cadastrado');
        die;
    }
    $showDe = $de;
    $de = explode('/', $de);
    $dtDe = $de[2] . '-' . $de[1] . '-' . $de[0];
    $showAte = $ate;
    $ate = explode('/', $ate);
    $dtAte = $ate[2] . '-' . $ate[1] . '-' . $ate[0];
    if ($arr['seguranca'] == 'NENHUM') {
        $arr['seguranca'] = '';
    }

    $tags = [['<relatorio>', 'Extrato de Conta Assinada'], ['<cliente>', $cli['stCliente']], ['<data>', $showDe . ' até ' . $showAte]];
    try {
        $mail->Host = $arr['servidor']; // Endereço do servidor SMTP (Autenticação, utilize o host smtp.seudomínio.com.br)
        $mail->SMTPAuth = true;  // Usar autenticação SMTP (obrigatório para smtp.seudomínio.com.br)
        $mail->Port = $arr['porta']; //  Usar 587 porta SMTP
        $mail->Username = $arr['email']; // Usuário do servidor SMTP (endereço de email)
        $mail->Password = $arr['senha']; // Senha do servidor SMTP (senha do email usado)
        $mail->SMTPSecure = strtolower($arr['seguranca']);

        //Define o remetente
        // =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
        $mail->SetFrom($arr['email'], $arr['nome']); //Seu e-mail
        $mail->AddReplyTo($arr['email'], $arr['nome']); //Seu e-mail

        $assunto = $arr['assunto'];
        $corpo = $arr['corpo'];

        for ($i = 0; $i < count($tags); $i++) {
            $assunto = str_replace($tags[$i][0], $tags[$i][1], $assunto);
            $corpo = str_replace($tags[$i][0], $tags[$i][1], $corpo);
        }


        $mail->Subject = $assunto;//Assunto do e-mail


        //Define os destinatário(s)
        //=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
        $mail->AddAddress($cli['stEmail'], $cli['stCliente']);

        if ($arr['flLido']) {
            $mail->AddCustomHeader("X-Confirm-Reading-To: " . $arr['email']);
            $mail->AddCustomHeader("Disposition-Notification-To: " . $arr['email']);
            $mail->AddCustomHeader("Return-receipt-to: " . $arr['email']);
        }

        //Campos abaixo são opcionais
        //=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
        //$mail->AddCC('destinarario@dominio.com.br', 'Destinatario'); // Copia
        //$mail->AddBCC('destinatario_oculto@dominio.com.br', 'Destinatario2`'); // Cópia Oculta
        //$mail->AddAttachment('images/phpmailer.gif');      // Adicionar um anexo

        //Define o corpo do email
        $mail->MsgHTML($corpo);
        ////Caso queira colocar o conteudo de um arquivo utilize o método abaixo ao invés da mensagem no corpo do e-mail.
        //$mail->MsgHTML(file_get_contents('arquivo.html'));


        $pdf = pdfExtrato($idCliente, $dtDe, $dtAte);
        $mail->AddStringAttachment($pdf, 'extrato.pdf');


        $rows[] = $mail->Send();
        $rows[] = "Mensagem enviada com sucesso";

        echo json_encode($rows);

        //caso apresente algum erro é apresentado abaixo com essa exceção.
    } catch (phpmailerException $e) {
        echo $e->errorMessage(); //Mensagem de erro costumizada do PHPMailer
    }
}

function pdfExtrato($idCliente, $de, $ate)
{
    $sql_relatorio = "SELECT 'VENDA' as Tipo, E.dtData, E.idCliente, E.idExtrato, E.idAbertura, E.vrTotal, E.vrQuitado, (E.vrTotal + E.vrQuitado) as vrSoma,E.vrDesconto, E.vrSaldoAnterior, C.stCliente, C.vrSaldo " .
        "FROM cli_Extrato E " .
        "INNER JOIN dlv_Clientes C ON C.idCliente = E.idCliente " .
        "WHERE E.idCliente = " . $idCliente . " AND E.dtData BETWEEN '" . $de . "' AND '" . $ate . "' AND E.flAtivo = '1' " .
        "UNION " .
        "SELECT " .
        "'DEPOSITO' as Tipo, P.dtData, P.idCliente, '0' as idExtrato, P.idAbertura, P.vrPagamento as vrTotal, '0' as vrQuitado, P.vrPagamento as vrSoma,0 as vrDesconto,P.vrSaldoAnterior, C.stCliente, C.vrSaldo " .
        "FROM cli_Pagamento P " .
        "INNER JOIN dlv_Clientes C ON C.idCliente = P.idCliente " .
        "WHERE P.idCliente = " . $idCliente . " AND P.dtData between '" . $de . "' AND '" . $ate . "' " .
        "UNION " .
        "SELECT 'TICKET' as Tipo, T.dtData, T.idCliente, '0' as idExtrato, '0' as idAbertura, T.vrDebito as vrTotal, '0' as vrQuitado, T.vrDebito as vrSoma,0 as vrDesconto, T.vrSaldoAnterior, C.stCliente, C.vrSaldo " .
        "FROM cx_Tickets T " .
        "INNER JOIN dlv_Clientes C ON C.idCliente = T.idCliente " .
        "WHERE T.idCliente = " . $idCliente . " AND T.dtData BETWEEN '" . $de . "' AND '" . $ate . "' " .
        "ORDER by dtData";
    $objResource = mssql_query($sql_relatorio);

    $table_rel = "<table style=\"width: 99.9%\">";

    $total_geral = 0;
    while ($Extrato = mssql_fetch_object($objResource)) :
        if ($Extrato->Tipo == "VENDA") :
            $total = 0;
            $linha_tipo = '<tr bgcolor="#666666">
		<td colspan="3"><font color="#ffffff"><b>[' . $Extrato->Tipo . '] ' . date("d/m/Y", strtotime($Extrato->dtData)) . '</b></font></td>
	</tr>';
            $table_rel .= $linha_tipo;
            $sql_itens_venda = "SELECT P.stProdutoAbreviado, M.flFracionado, M.stMedida, I.dtData, C.idCodigo, sum(I.vrTotal) as vrTotal, sum(I.nrQuantidade) as nrQuantidade, P.vrUnitario AS vrUnitarioAtual
	FROM cli_ItemExtrato I
	INNER JOIN prd_Produtos P on P.idProduto = I.idProduto
	INNER JOIN prd_Medidas M on M.idMedida = P.idMedida
	INNER JOIN (SELECT MIN(idCodigo) AS idCodigo, idProduto FROM prd_Codigos GROUP BY idProduto) C on C.idProduto = P.idProduto
	WHERE idabertura = " . $Extrato->idAbertura . " AND idExtrato = " . $Extrato->idExtrato . " AND I.flAtivo = '1'
	GROUP BY P.stProdutoAbreviado, M.flFracionado, M.stMedida, I.dtData, C.idCodigo, P.vrUnitario";
            $objRsc = mssql_query($sql_itens_venda);
            while ($Item = mssql_fetch_object($objRsc)) :
                $qnt = ($Item->flFracionado ? number_format(($Item->nrQuantidade / 100), 3, '.', '') : (int)$Item->nrQuantidade);
                $c = 0;
                $linha_item = '<tr bgcolor="' . (($c++ & 1) ? '#F0F0F0' : '') . '">
	<td>' . $Item->stProdutoAbreviado . '</td>
	<td>' . $qnt . ' ' . $Item->stMedida . '</td>
	<td>R$ ' . number_format($Item->vrTotal, 2, ',', '.') . '</td>
</td>';
                $table_rel .= $linha_item;
                $total += $Item->vrTotal;
            endwhile;

            $linha_desconto = '<tr bgcolor="#cccccc">
<td colspan="2" style=\"text-align: right; color: #fff; \">DESCONTO EM VENDA:</td>
<td>' . number_format($Extrato->vrDesconto, 2, ',', '.') . '</td>
</tr>';
            $subtotal = $total - $Extrato->vrQuitado + $Extrato->vrDesconto;
            $linha_debito = '<tr bgcolor="#cccccc">
<td colspan="2" style=\"text-align: right; color: #fff;\">DEBITO EM VENDA:</td>
<td>R$ ' . number_format($subtotal, 2, ',', '.') . '</td>
</tr>';
            $table_rel .= $linha_desconto;
            $table_rel .= $linha_debito;
            $total_geral += $subtotal;
        elseif ($Extrato->Tipo == "TICKET") :
            $linha_ticket = '<tr bgcolor="#cccccc">
<td colspan="2" style=\"text-align: right;\">[' . $Extrato->Tipo . '] ' . date("d/m/Y", strtotime($Extrato->dtData)) . '</td>
<td>R$ ' . number_format($Extrato->vrTotal, 2, ',', '.') . '</td>
</tr>';
            $table_rel .= $linha_ticket;
            $total_geral += $Extrato->vrTotal;
        else :
            $linha_deposito = '<tr bgcolor="#cccccc">
<td colspan="2" style=\"text-align: right; color: #fff; \">[' . $Extrato->Tipo . '] ' . date("d/m/Y", strtotime($Extrato->dtData)) . '</td>
<td>R$ ' . number_format($Extrato->vrTotal, 2, ',', '.') . '</td>
</tr>';
            $table_rel .= $linha_deposito;
            $total_geral -= $Extrato->vrTotal;
        endif;
    endwhile;

    $linha_total_periodo = '<tr bgcolor="#cccccc">
<td colspan="2" style=\"text-align: right;\">VALOR TOTAL DO PERÍODO R$:</td>
<td>R$ ' . number_format($total_geral, 2, ',', '.') . '</td>
</tr>';

    $sql_cliente = "SELECT TOP(1) c.idCliente, c.stCliente, cp.stEndereco, c.nrNumero, cp.stBairro, cp.stCidade, cp.stEstado, cp.stCEP, c.vrSaldo
FROM dlv_Clientes c
INNER JOIN dlv_CEPs cp
ON c.idCEP = cp.idCEP
WHERE c.idCliente = " . $idCliente;
    $Cliente = mssql_fetch_object(mssql_query($sql_cliente));

    $linha_saldo = '<tr bgcolor="#6666666">
<td colspan="2" colspan="2" style=\"text-align: right;\"><font color="#ffffff">SALDO ATUAL R$:</font></td>
<td><font color="#ffffff">R$ ' . number_format($Cliente->vrSaldo, 2, ',', '.') . '</font></td>
</tr>';

    $table_rel .= $linha_total_periodo;
    $table_rel .= $linha_saldo;

    $table_cliente =
        "
            <h2 style=\"text-align: center;\">Extrato de Cliente</h2>
            <center style=\"text-align: center;\"><span><b>Data de Emissão:</b> " . date("d/m/Y H:i:s") . "h</span></center>
            <br />
            <table>
                <tbody>
                    <tr>
                        <td style=\"text-align: right;\"><b>Cliente:</b></td>
                        <td>" . $Cliente->stCliente . "</td>
                    </tr>
                    <tr>
                        <td style=\"text-align: right;\"><b>Endereço:</b></td>
                        <td>" . $Cliente->stEndereco . "," . $Cliente->nrNumero . " - " . $Cliente->stBairro . " - " . $Cliente->stCidade . "," . $Cliente->stEstado . "</td>
                    </tr>
                    <tr>
                        <td style=\"text-align: right;\"><b>CEP:</b></td>
                        <td>" . $Cliente->stCEP . "</td>
                    </tr>
                </tbody>
            </table>
            <br /><br />
";

    $table_rel .= "</table>";

    $header = '<div style="font-size: 10px; text-align: right;">NATI Retaguarda, {DATE d/m/Y} pag. {PAGENO} de {nb}</div>';
    $footer = '<div style="font-size: 10px; text-align: center;">© 2001 - ' . date("Y") . ', Arcnet Automação Comercial. Todos os direitos reservados.</div>';

//    $objPdf = new mPDF();
    $objPdf = new \Mpdf\Mpdf();
    $objPdf->SetHTMLHeader($header);
    $objPdf->WriteHTML($table_cliente);
    $objPdf->WriteHTML($table_rel);
    $objPdf->SetHTMLFooter($footer);
    $pdf = $objPdf->Output('extrato_cliente.pdf', 'S');

    return $pdf;
}

?>
