<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Http\Requests\Nati\FichaTecnicaCreateRequest;
use App\Services\Nati\FichaTecnicaService;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Prettus\Validator\Exceptions\ValidatorException;


class FichaTecnicaController extends Controller
{

    protected $service;

    public function __construct(FichaTecnicaService $service)
    {
        $this->service = $service;
    }

    public function store(FichaTecnicaCreateRequest $request)
    {
        try {
            $this->service->insert($request->all());

            return response()->json(["created"], 201);
        }catch (ModelNotFoundException $e) {
            return response()->json([
                'error'   => true,
                'message' => $e->getMessage()
            ], 400);
        }
        catch (ValidatorException $e) {
            return response()->json([
                'error'   => true,
                'message' => $e->getMessageBag()
            ], 404);
        }
    }

}
