<?php

namespace App\Http\Controllers\Financeiro;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Services\Financeiro\LancamentosService;
use Prettus\Validator\Exceptions\ValidatorException;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use App\Http\Requests\Financeiro\LancamentosCreateRequest;
use App\Http\Requests\Financeiro\LancamentosUpdateRequest;

class LancamentosController extends Controller
{

    protected $service;

    public function __construct(LancamentosService $service)
    {
        $this->service = $service;
    }


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function index()
    {
        try
        {
            $lancamentos = $this->service->get();

            return response()->json($lancamentos);
        }
        catch(\Exception $exception)
        {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 404);
        }
    }

    public function getLancamento(Request $request)
    {
        try
        {
            $lancamento = $this->service->getLancamento($request);

            return response()->json($lancamento);
        }
        catch (ModelNotFoundException $e)
        {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 404);

        }
        catch (\Exception $e)
        {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 500);
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  LancamentosCreateRequest $request
     *
     * @return \Illuminate\Http\JsonResponse
     */

    public function find(Request $request)
    {
        try
        {
            $lancamento = $this->service->find($request);

            return response()->json($lancamento);
        }
        catch(\Exception $exception)
        {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 404);
        }
    }

    public function store(LancamentosCreateRequest $request)
    {
        try {
            $contasReceber = $this->service->insert($request->all());
            return response()->json([
                'message' => 'Contas a Receber created',
                'data' => $contasReceber
            ]);

        } catch (ValidatorException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessageBag()
            ], 404);
        }
    }

    public function view($idContasReceber, $idCliente)
    {
        try
        {
            $contasReceber = $this->service->getById($idContasReceber, $idCliente);

            return response()->json($contasReceber);
        }
        catch (ModelNotFoundException $e)
        {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 404);

        }
        catch (\Exception $e)
        {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 500);
        }
    }


    public function setBaixa(LancamentosUpdateRequest $request, $idContasReceber, $idCliente)
    {

        try {
            $response = $this->service->setBaixa($request->all(), $idContasReceber, $idCliente);
            return response()->json([
                'message' => 'Contas a Receber Update',
                'data' => $response
            ]);

        } catch (ValidatorException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessageBag()
            ], 500);
        }
    }

    public function selectBaixa(Request $request)
    {
        try {
            $response = $this->service->selectBaixa($request->all());
            return response()->json([
                'message' => 'Lançamentos Editado com sucesso',
                'data' => $response
            ]);
        } catch (ValidatorException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessageBag()
            ], 500);
        }
    }


    public function estorno($idContasReceber, $idCliente)
    {
        try {
            $response = $this->service->estorno($idContasReceber, $idCliente);
            return response()->json([
                'message' => 'Contas a Receber Update',
                'data' => $response
            ]);

        } catch (ValidatorException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessageBag()
            ], 500);
        }
    }

    public function atualizar(LancamentosUpdateRequest $request, $idContasReceber, $idCliente)
    {

        try {
            $response = $this->service->atualizar($request->all(), $idContasReceber, $idCliente);
            return response()->json([
                'message' => 'Contas a Receber Update',
                'data' => $response
            ]);

        } catch (ValidatorException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessageBag()
            ], 500);
        }
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function delete($idContasReceber, $idCliente)
    {
        try {
            $response = $this->service->delete($idContasReceber, $idCliente);
            return response()->json([
                'message' => 'Conta Receber removida',
                'data' => $response
            ]);

        } catch (ValidatorException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessageBag()
            ], 500);
        }
    }
}
