<?php

namespace App\Http\Controllers;

use App\Entities\Logs;
use App\Http\Requests\Nati\MedidaCreateRequest;
use App\Http\Requests\Nati\MedidaUpdateRequest;
use Illuminate\Database\Eloquent\ModelNotFoundException;

use Illuminate\Http\JsonResponse;
use App\Http\Requests\Nati\MeasureCreateRequest;
use App\Http\Requests\Nati\MeasureUpdateRequest;
use App\Services\Nati\MeasureService;
use Prettus\Validator\Exceptions\ValidatorException;
use App\Entities\Nati\Measure;


class MeasuresController extends Controller
{

    protected $service;


    public function __construct(MeasureService $service)
    {
        $this->service = $service;
    }


    /**
     * Display a listing of the resource.
     *
     * @return JsonResponse
     */
    public function index()
    {
        try {
            $medidas = $this->service->all();

            return response()->json($medidas);
        } catch (\Exception $exception) {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 404);
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  MedidaCreateRequest $request
     *
     * @return JsonResponse
     */
    public function store(MeasureCreateRequest $request)
    {
        try {
            $user = auth()->user();
            $medida = $this->service->create($request->all());
            Logs::writeLog($user->stApelido, "MEDIDAS", 'O USUARIO [' . $user->stApelido . '] CADASTROU A MEDIDA [' . $medida->stMedida . ']');

            $response = [
                'message' => 'Medida created.',
                'data' => $medida->toArray(),
            ];
            return response()->json($response, 201);

        } catch (ModelNotFoundException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 400);
        } catch (ValidatorException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessageBag()
            ], 404);
        }
    }


    /**
     * Display the specified resource.
     *
     * @param  int $id
     *
     * @return JsonResponse
     */
    public function show($id)
    {
        try {
            $medida = $this->service->getById($id);

            return response()->json($medida);
        } catch (\Exception $exception) {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 404);
        }
    }


    /**
     * Update the specified resource in storage.
     *
     * @param  MedidaUpdateRequest $request
     * @param  string $id
     *
     * @return JsonResponse
     */
    public function update(MeasureUpdateRequest $request, $id)
    {
        try {
            $user = auth()->user();
            $oldNameMeasure = Measure::where('idMedida', $id)->first();
            $response = $this->service->update($request->all(), $id);

            Logs::writeLog($user->stApelido, "PRODUTOS", 'O USUARIO [' . $user->stApelido . '] ALTEROU O NOME DA MEDIDA [' . $oldNameMeasure->stMedida . '] ' . 'PARA [' . $response->stMedida . ']');
            return response()->json([
                'message' => 'Medidas Update',
                'data' => $response
            ], 201);


        } catch (ModelNotFoundException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 400);

        } catch (ValidatorException $e) {

            return response()->json([
                'error' => true,
                'message' => $e->getMessageBag()
            ], 404);
        }

    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     *
     * @return JsonResponse
     */
    public function destroy($id)
    {
        try {
            $user = auth()->user();
            $oldNameMeasure = Measure::where('idMedida', $id)->first();
            $medida = $this->service->delete($id);

            Logs::writeLog($user->stApelido, "MEDIDAS", 'O OPERADOR [' . $user->stApelido . '] DESATIVOU A MEDIDA [' . $oldNameMeasure->stMedida . ']');

            $response = [
                'message' => 'Medida deletada.',
                'data' => $medida,
            ];
            return response()->json($response);

        } catch (\Exception $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 400);
        }
    }

    public function transfer($idMedida, $idMedidaNew)
    {
        try {
            $medida = $this->service->transfer($idMedida, $idMedidaNew);

            $response = [
                'message' => 'Medida transferida com sucesso.',
                'data' => $medida,
            ];
            return response()->json($response);

        } catch (\Exception $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 400);
        }
    }
}
