<?php

namespace App\Listeners;

use App\Events\DeliveryOrderCfeCreated;
use App\Services\Sales\SalesService;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;

class DeliveryOrderCfeListener
{
    protected $saleService;
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct(SalesService $salesService)
    {
        $this->saleService = $salesService;
    }

    /**
     * Handle the event.
     *
     * @param  DeliveryOrderCfeCreated  $event
     * @return void
     */
    public function handle(DeliveryOrderCfeCreated $event)
    {
        if ($event->order){
            $this->saleService->setChaveFiscal($event->order);
        }
    }
}
