<?php

namespace App\Repositories;

use Prettus\Repository\Eloquent\BaseRepository;
use Prettus\Repository\Criteria\RequestCriteria;
use App\Repositories\ProductCompositeRepository;
use App\Entities\ProductComposite;
use App\Validators\ProductCompositeValidator;

/**
 * Class ProductCompositeRepositoryEloquent.
 *
 * @package namespace App\Repositories;
 */
class ProductCompositeRepositoryEloquent extends BaseRepository implements ProductCompositeRepository
{
    /**
     * Specify Model class name
     *
     * @return string
     */
    public function model()
    {
        return ProductComposite::class;
    }

    /**
    * Specify Validator class name
    *
    * @return mixed
    */
    public function validator()
    {

        return ProductCompositeValidator::class;
    }


    /**
     * Boot up the repository, pushing criteria
     */
    public function boot()
    {
        $this->pushCriteria(app(RequestCriteria::class));
    }
    
}
