<?php
/**
 * Created by PhpStorm.
 * User: clecio
 * Date: 14/06/2017
 * Time: 10:29
 */

namespace App\Services;

use App\Entities\ContasReceber;
use App\Entities\Financeiro\ContasReceberView;
use App\Repositories\ContasReceberRepository;
use App\Validators\ContasReceberValidator;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Str;
use Prettus\Validator\Contracts\ValidatorInterface;

class ContasReceberService
{
    private $repository;
    private $validator;

    public function __construct(ContasReceberRepository $repository, ContasReceberValidator $validator)
    {
        $this->repository = $repository;
        $this->validator = $validator;
    }

    public function get($request)
    {
        $fd = Carbon::createFromFormat('d/m/Y', $request['start'])->toDateString();
        $first_date = $fd . ' 00:00:00';
        $ld = Carbon::createFromFormat('d/m/Y', $request['end'])->toDateString();
        $last_date = $ld . ' 23:59:59';
        $order = !isset($request['order']) ? 'DESC' : Str::upper($request['order']);
        $sort = $request['sort'] == '' ? 'vencimento' : $request['sort'];

        $q = ContasReceberView::select('*')
            ->whereBetween(DB::raw('cast(vencimento AS DATE)'), [$first_date, $last_date]);

        if ($request['active'] == 'false') {
            $q->where('recebido', true);
        }

        $q->orderBy($sort, $order);

        $contasReceber = $q->paginate($request['limit'], $request['page']);
        return $contasReceber;
    }

    public function getById($idContasReceber, $idCliente)
    {
        $contasReceber = $this->repository->findWhere([
            'idContasReceber' => $idContasReceber,
            'idCliente' => $idCliente
        ])->first();

        return $contasReceber;
    }


    public function insert($request)
    {
        $contasReceber = $this->data($request);

        $this->validator->with($contasReceber)->passesOrFail(ValidatorInterface::RULE_CREATE);

        return $this->repository->create($contasReceber);
    }

    public function update($request, $idContasReceber, $idCliente)
    {
        $contasReceber = $this->data($request);
        unset($contasReceber['idContasReceber']);

        $this->validator->with($contasReceber)->passesOrFail(ValidatorInterface::RULE_UPDATE);

        return $this->repository->findWhere([
            'idContasReceber' => $idContasReceber,
            'idCliente' => $idCliente
        ])->first()->update($contasReceber);
    }

    public function delete($idContasReceber, $idCliente)
    {
        return $this->repository->findWhere([
            'idContasReceber' => $idContasReceber,
            'idCliente' => $idCliente
        ])->first()->update(['flAtivo' => "0"]);

    }

    public function getNextId($cliente)
    {
        if($this->repository->all()->where('idCliente', $cliente)->last()){
            return $idContasReceber = $this->repository->all()->where('idCliente', $cliente)->last()->idContasReceber;
        }else{
            return $idContasReceber = 0;
        }
    }

    public function data($request)
    {
        if (isset($request['flBaixarAgora'])) {
            $flAtivo = 0;
            $dtRecebimento = Carbon::now();
            $vrRecebido = $request['vrDocumento'];
        }else{
            $flAtivo = 1;
            $dtRecebimento = null;
            $vrRecebido = 0.00;
        }

        $dtLancamento = str_replace('/','-',$request['dtLancamento']);
        $dtVencimento = str_replace('/','-',$request['dtVencimento']);

        $contasReceber = [
            "idContasReceber" => $this->getNextId($request['idCliente']) + 1,
            "idCliente" => $request['idCliente'],
            "idTipoConta" => $request['idTipoConta'],
            "dtLancamento" => date("Y-m-d", strtotime($dtLancamento)),
            "dtVencimento" => date("Y-m-d", strtotime($dtVencimento)),
            "dtRecebimento" => $dtRecebimento,
            "nrParcela" => 1,
            "nrTotalParcelas" => $request['nrTotalParcelas'],
            "vrDocumento" => $request['vrDocumento'],
            "vrRecebido" => $vrRecebido,
            "vrJuros" => 0.00,
            "flJuros" => null,
            "flRecebido" => 0,
            "flAtivo" => $flAtivo,
            "stOperador" => $request['stOperador'],
            "stObservacao" => $request['stObservacao'],
            "stDocumento" => $request['stDocumento'],
            "stTipoBaixa" => 'I',
            "stTipoJuros" => 'P',
            "idFormaPagamento" => $request['idFormaPagamento'],
            "stObservacaoBaixa" => null,
            "vrDescontoLancamento" => $request['vrDescontoLancamento'],
            "idContaBancaria" => 0,
            "idConta" => $request['idConta'],
            "dtAlteracao" => Carbon::now(),
            "idTipopagamento" => 1,
            "flMensalidae" => 0,
            "stFormato" => $request['stFormato']
        ];

        return $contasReceber;
    }
}
