<?php

namespace App\Services\Financeiro;

use Carbon\Carbon;
use App\Repositories\ContaBancariaRepository;
use App\Validators\Financeiro\ContaBancariaValidator;
use Prettus\Validator\Contracts\ValidatorInterface;

class ContaBancariaService
{
    private $repository;
    private $validator;

    public function __construct(ContaBancariaRepository $repository, ContaBancariaValidator $validator)
    {
        $this->repository = $repository;
        $this->validator = $validator;
    }

    public function get()
    {
        $this->repository->pushCriteria(app('Prettus\Repository\Criteria\RequestCriteria'));
        $contasBancarias = $this->repository->all();

        return $contasBancarias;
    }

    public function getById($id)
    {
        $contaBancaria = $this->repository->find($id);

        return  $contaBancaria;

    }


    public function insert($request)
    {
        if ($this->repository->all()->last()) {
            $idContaBancaria = $this->repository->all()->last()->idContaBancaria;
        } else {
            $idContaBancaria = 0;
        }

        $contaBancaria = [

            "idContaBancaria" => $idContaBancaria + 1,
            "stContaBancaria" => $request['stContaBancaria'],
            "stBanco" => $request['stBanco'],
            "stAgencia" => $request['stAgencia'],
            "vrSaldo" => 0.00,
            "flAtivo" => $request['flAtivo'],
            "dtAlteracao" => Carbon::now(),
            "stApelido" => "",
            "flPoupanca" => $request['flPoupanca'],
        ];

        $this->validator->with($contaBancaria)->passesOrFail(ValidatorInterface::RULE_CREATE);

        return $this->repository->create($contaBancaria);
    }

    public function update($data, $id)
    {
        $this->validator->with($data)->passesOrFail(ValidatorInterface::RULE_UPDATE);
        return $this->repository->update($data, $id);
    }

    public function delete($id)
    {
        return $this->repository->update(['flAtivo' => false], $id);
    }

    public function updateSaldoAdd($id, $newValue)
    {
        $contaBancaria = $this->repository->find($id);
        return $this->repository->update(['vrSaldo' => $contaBancaria->vrSaldo + $newValue], $id);
    }

    public function updateSaldoDeduct($id, $valor)
    {
        $contaBancaria = $this->repository->find($id);
        return $this->repository->update(['vrSaldo' => $contaBancaria->vrSaldo - $valor], $id);
    }

}
