<?php

namespace App\Services\Nati;

use Carbon\Carbon;
use App\Entities\Nati\Nutritional;
use App\Repositories\Nati\InformationNutritionalRepository;
use App\Validators\Nati\InformationNutritionalValidator;

class InformationNutritionalService
{
    protected $repository;
    protected $validator;

    public function __construct(InformationNutritionalRepository $repository, InformationNutritionalValidator $validator)
    {
        $this->repository = $repository;
        $this->validator = $validator;
    }

    public function get()
    {
        return $this->repository->all();
    }

    public function getById($id_product)
    {
        return $this->repository->findWhere(['idProduto' => $id_product])->first();
    }

    public function insert($nutritional, $id_product)
    {
        $nutritional['idTabelaNutricional'] =  Nutritional::max('idTabelaNutricional') + 1;
        $nutritional['idProduto'] = $id_product;
        $this->repository->create($nutritional);
        return;
    }

    public function update($nutritional)
    {
        $this->repository->update($nutritional, $nutritional['idTabelaNutricional']);
        return;
    }
    public function deleteByIdProduct($id_product)
    {
        return Nutritional::where('idProduto', $id_product)->delete();
    }

    public function delete($id)
    {
        return $this->repository->delete($id);
    }
}
