<?php

namespace App\Services\Nati;

use App\Entities\Nati\Pergunta;
use App\Entities\Nati\Product;
use App\Entities\Nati\ProdutoPergunta;
use App\Entities\Nati\Resposta;
use App\Services\Service;
use Illuminate\Support\Facades\Cache;
use App\Repositories\Nati\PerguntaRepository;
use App\Validators\Nati\PerguntaValidator;
use Illuminate\Support\Facades\DB;

class PerguntasService extends Service
{
    private $repository;
    private $validator;
    private $respostaService;
    private $produtoPerguntaService;
    private $respostaObservacaoService;
    private $respostaProdutoService;

    /**
     * PerguntaService constructor.
     * @param PerguntaRepository $repository
     * @param PerguntaValidator $validator
     */
    public function __construct(PerguntaRepository $repository, PerguntaValidator $validator, RespostaService $respostaService, ProdutoPerguntaService $produtoPerguntaService, RespostaProdutoService $respostaProdutoService, RespostaObservacaoService $respostaObservacaoService)
    {
        $this->repository = $repository;
        $this->validator = $validator;
        $this->respostaService = $respostaService;
        $this->produtoPerguntaService = $produtoPerguntaService;
        $this->respostaProdutoService = $respostaProdutoService;
        $this->respostaObservacaoService = $respostaObservacaoService;
    }
    public function getAll($request)
    {
        if($request['filter']) {
            return Pergunta::with('respostas')
                ->with('produtos')
                ->where('stPergunta', 'LIKE', "%$request[filter]%")
                ->where('flAtivo', true)
                ->orderBy('stPergunta','asc')
                ->paginate(10);
            }

            $response = Pergunta::with('respostas')
                ->with('produtos')
                ->orderBy('stPergunta','asc')
                ->where('flAtivo', true)
                ->paginate(10);

            return $response;
    }

    public function store($request)
    {

        $this->validator->with($request)->passesOrFail();
        $question = Pergunta::create([
            'stPergunta' => $request['description'],
            'flAtivo' => true,
            'minOpcoes' => $request['minOptions'],
            'maxOpcoes' => $request['maxOptions'],
            'flObrigatoria' => $request['isMandatory']
        ]);

        $response = $this->respostaService->store($request, $question->idPergunta);
        return $response;

    }

    public function filter($data)
    {
        return Pergunta::select([
            'idPergunta',
            'stPergunta'
        ])
//            ->join('prd_codigos', 'prd_produtos.idProduto', '=', 'prd_Codigos.idProduto')
//            ->where('prd_Perguntas.flAtivo', true)
//            ->where(function ($query) use ($data) {
//                $query->where('prd_Codigos.idCodigo', "$data")
//                    ->orWhere('prd_Produtos.stProdutoAbreviado', 'LIKE', "%$data%");
//            })
                ->where('prd_perguntas.stPergunta', 'like', "%$data%")
//            ->where('prd_Codigos.idCodigo', '<>', '-100')
            ->groupBy('prd_perguntas.idPergunta', 'prd_perguntas.stPergunta')
            ->paginate(10);
    }

    public function show($id)
    {
        $pergunta = $this->repository->with('respostas')->with('produtos')->find($id);
        $respostasProdutos = [];
        $respostasObservacoes = [];
        foreach ($pergunta->respostas as $resposta) {
            if($resposta['idTipoResposta'] === 1) {
                $respostaProduto = $this->respostaProdutoService->getWithProductByIdRespostaProduto($resposta['idRespostaProduto']);
                $respostaProduto['nrOrdem'] = $resposta['nrOrdem'];
                array_push($respostasProdutos, $respostaProduto);
            }
            if($resposta['idTipoResposta'] === 2) {
                $respostaObservacao = $this->respostaObservacaoService->show($resposta['idRespostaObservacao']);
                $respostaObservacao['nrOrdem'] = $resposta['nrOrdem'];
                array_push($respostasObservacoes, $respostaObservacao);
            }


        }
        if($respostasProdutos) $pergunta['respostasProdutos'] = $respostasProdutos;
        if($respostasObservacoes) $pergunta['respostasObservacoes'] = $respostasObservacoes;
        return $pergunta;
    }
    public function delete($idPergunta)
    {
        $pergunta = $this->repository->find($idPergunta);
        if(!$pergunta) throw new \Exception('Pergunta não encontrada');

        $this->respostaService->deleteByIdPergunta($idPergunta);
        $this->produtoPerguntaService->deleteByIdPergunta($idPergunta);
        $this->repository->where('idPergunta', $pergunta->idPergunta)->delete();
    }

    public function update($request)
    {
        $pergunta = Pergunta::where('idPergunta',  $request['idPergunta'])->first();
        $pergunta->stPergunta = $request['description'];
        $pergunta->minOpcoes = $request['minOptions'];
        $pergunta->maxOpcoes = $request['maxOptions'];
        $pergunta->flObrigatoria = $request['isMandatory'];
        $pergunta->save();

        $this->respostaService->deleteByIdPergunta($request['idPergunta']);
        $this->respostaService->store($request, $request['idPergunta']);

        return $this->repository
                        ->with('respostas')
                        ->with('produtos')
                        ->findWhere(['idPergunta' => $request['idPergunta']]);
    }
}
